/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class ApiVersionsResponseData
implements ApiMessage {
    short errorCode;
    ApiVersionsResponseKeyCollection apiKeys;
    int throttleTimeMs;
    SupportedFeatureKeyCollection supportedFeatures;
    long finalizedFeaturesEpoch;
    FinalizedFeatureKeyCollection finalizedFeatures;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The top-level error code."), new Field("api_keys", (Type)new ArrayOf((Type)ApiVersionsResponseKey.SCHEMA_0), "The APIs supported by the broker.")});
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public ApiVersionsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ApiVersionsResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ApiVersionsResponseData() {
        this.errorCode = 0;
        this.apiKeys = new ApiVersionsResponseKeyCollection(0);
        this.throttleTimeMs = 0;
        this.supportedFeatures = new SupportedFeatureKeyCollection(0);
        this.finalizedFeaturesEpoch = -1L;
        this.finalizedFeatures = new FinalizedFeatureKeyCollection(0);
    }

    public short apiKey() {
        return 18;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 3;
    }

    public void read(Readable _readable, short _version) {
        int i;
        ApiVersionsResponseKeyCollection newCollection;
        int arrayLength;
        this.errorCode = _readable.readShort();
        if (_version >= 3) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field apiKeys was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ApiVersionsResponseKeyCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ApiVersionsResponseKey(_readable, _version));
            }
            this.apiKeys = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field apiKeys was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ApiVersionsResponseKeyCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ApiVersionsResponseKey(_readable, _version));
            }
            this.apiKeys = newCollection;
        }
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this.supportedFeatures = new SupportedFeatureKeyCollection(0);
        this.finalizedFeaturesEpoch = -1L;
        this.finalizedFeatures = new FinalizedFeatureKeyCollection(0);
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block7: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        int i2;
                        int arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            throw new RuntimeException("non-nullable field supportedFeatures was serialized as null");
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ImplicitLinkedHashMultiCollection newCollection2 = new SupportedFeatureKeyCollection(arrayLength2);
                        for (i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add((ImplicitLinkedHashCollection.Element)new SupportedFeatureKey(_readable, _version));
                        }
                        this.supportedFeatures = newCollection2;
                        continue block7;
                    }
                    case 1: {
                        this.finalizedFeaturesEpoch = _readable.readLong();
                        continue block7;
                    }
                    case 2: {
                        int i2;
                        int arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            throw new RuntimeException("non-nullable field finalizedFeatures was serialized as null");
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ImplicitLinkedHashMultiCollection newCollection2 = new FinalizedFeatureKeyCollection(arrayLength2);
                        for (i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add((ImplicitLinkedHashCollection.Element)new FinalizedFeatureKey(_readable, _version));
                        }
                        this.finalizedFeatures = newCollection2;
                        continue block7;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        ApiVersionsResponseKey apiKeysElement;
        Iterator iterator;
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        if (_version >= 3) {
            _writable.writeUnsignedVarint(this.apiKeys.size() + 1);
            iterator = this.apiKeys.iterator();
            while (iterator.hasNext()) {
                apiKeysElement = (ApiVersionsResponseKey)iterator.next();
                apiKeysElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.apiKeys.size());
            iterator = this.apiKeys.iterator();
            while (iterator.hasNext()) {
                apiKeysElement = (ApiVersionsResponseKey)iterator.next();
                apiKeysElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 3) {
            if (!this.supportedFeatures.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.supportedFeatures.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default supportedFeatures at version " + _version);
        }
        if (_version >= 3 && this.finalizedFeaturesEpoch != -1L) {
            ++_numTaggedFields;
        }
        if (_version >= 3) {
            if (!this.finalizedFeatures.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.finalizedFeatures.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default finalizedFeatures at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 3) {
            Iterator iterator2;
            _writable.writeUnsignedVarint(_numTaggedFields);
            if (!this.supportedFeatures.isEmpty()) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes((Object)this.supportedFeatures));
                _writable.writeUnsignedVarint(this.supportedFeatures.size() + 1);
                iterator2 = this.supportedFeatures.iterator();
                while (iterator2.hasNext()) {
                    SupportedFeatureKey supportedFeaturesElement = (SupportedFeatureKey)iterator2.next();
                    supportedFeaturesElement.write(_writable, _cache, _version);
                }
            }
            if (this.finalizedFeaturesEpoch != -1L) {
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.finalizedFeaturesEpoch);
            }
            if (!this.finalizedFeatures.isEmpty()) {
                _writable.writeUnsignedVarint(2);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes((Object)this.finalizedFeatures));
                _writable.writeUnsignedVarint(this.finalizedFeatures.size() + 1);
                iterator2 = this.finalizedFeatures.iterator();
                while (iterator2.hasNext()) {
                    FinalizedFeatureKey finalizedFeaturesElement = (FinalizedFeatureKey)iterator2.next();
                    finalizedFeaturesElement.write(_writable, _cache, _version);
                }
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 3) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.errorCode = struct.getShort("error_code");
        Object[] _nestedObjects = struct.getArray("api_keys");
        this.apiKeys = new ApiVersionsResponseKeyCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.apiKeys.add(new ApiVersionsResponseKey((Struct)nestedObject, _version));
        }
        this.throttleTimeMs = _version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        if (_version >= 3) {
            if (_taggedFields.containsKey(0)) {
                _nestedObjects = (Object[])_taggedFields.remove(0);
                this.supportedFeatures = new SupportedFeatureKeyCollection(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.supportedFeatures.add(new SupportedFeatureKey((Struct)nestedObject, _version));
                }
            } else {
                this.supportedFeatures = new SupportedFeatureKeyCollection(0);
            }
        } else {
            this.supportedFeatures = new SupportedFeatureKeyCollection(0);
        }
        this.finalizedFeaturesEpoch = _version >= 3 ? (_taggedFields.containsKey(1) ? (Long)_taggedFields.remove(1) : -1L) : -1L;
        if (_version >= 3) {
            if (_taggedFields.containsKey(2)) {
                _nestedObjects = (Object[])_taggedFields.remove(2);
                this.finalizedFeatures = new FinalizedFeatureKeyCollection(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.finalizedFeatures.add(new FinalizedFeatureKey((Struct)nestedObject, _version));
                }
            } else {
                this.finalizedFeatures = new FinalizedFeatureKeyCollection(0);
            }
        } else {
            this.finalizedFeatures = new FinalizedFeatureKeyCollection(0);
        }
        if (_version >= 3 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        Object element;
        TreeMap<Integer, Object> _taggedFields = null;
        if (_version >= 3) {
            _taggedFields = new TreeMap<Integer, Object>();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("error_code", (Object)this.errorCode);
        Struct[] _nestedObjects = new Struct[this.apiKeys.size()];
        int i = 0;
        Iterator iterator = this.apiKeys.iterator();
        while (iterator.hasNext()) {
            element = (ApiVersionsResponseKey)iterator.next();
            _nestedObjects[i++] = ((ApiVersionsResponseKey)element).toStruct(_version);
        }
        struct.set("api_keys", (Object)_nestedObjects);
        if (_version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        if (_version >= 3) {
            if (!this.supportedFeatures.isEmpty()) {
                _nestedObjects = new Struct[this.supportedFeatures.size()];
                i = 0;
                iterator = this.supportedFeatures.iterator();
                while (iterator.hasNext()) {
                    element = (SupportedFeatureKey)iterator.next();
                    _nestedObjects[i++] = ((SupportedFeatureKey)element).toStruct(_version);
                }
                _taggedFields.put(0, _nestedObjects);
            }
        } else if (!this.supportedFeatures.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default supportedFeatures at version " + _version);
        }
        if (_version >= 3 && this.finalizedFeaturesEpoch != -1L) {
            _taggedFields.put(1, this.finalizedFeaturesEpoch);
        }
        if (_version >= 3) {
            if (!this.finalizedFeatures.isEmpty()) {
                _nestedObjects = new Struct[this.finalizedFeatures.size()];
                i = 0;
                iterator = this.finalizedFeatures.iterator();
                while (iterator.hasNext()) {
                    element = (FinalizedFeatureKey)iterator.next();
                    _nestedObjects[i++] = ((FinalizedFeatureKey)element).toStruct(_version);
                }
                _taggedFields.put(2, _nestedObjects);
            }
        } else if (!this.finalizedFeatures.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default finalizedFeatures at version " + _version);
        }
        if (_version >= 3) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 2;
        int _arraySize = 0;
        _arraySize = _version >= 3 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.apiKeys.size() + 1))) : (_arraySize += 4);
        Iterator iterator = this.apiKeys.iterator();
        while (iterator.hasNext()) {
            ApiVersionsResponseKey apiKeysElement = (ApiVersionsResponseKey)iterator.next();
            _arraySize += apiKeysElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 1) {
            _size += 4;
        }
        if (_version >= 3 && !this.supportedFeatures.isEmpty()) {
            ++_numTaggedFields;
            ++_size;
            _arraySize = 0;
            _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.supportedFeatures.size() + 1));
            iterator = this.supportedFeatures.iterator();
            while (iterator.hasNext()) {
                SupportedFeatureKey supportedFeaturesElement = (SupportedFeatureKey)iterator.next();
                _arraySize += supportedFeaturesElement.size(_cache, _version);
            }
            _cache.setArraySizeInBytes((Object)this.supportedFeatures, _arraySize);
            _size += _arraySize + ByteUtils.sizeOfUnsignedVarint((int)_arraySize);
        }
        if (_version >= 3 && this.finalizedFeaturesEpoch != -1L) {
            ++_numTaggedFields;
            ++_size;
            ++_size;
            _size += 8;
        }
        if (_version >= 3 && !this.finalizedFeatures.isEmpty()) {
            ++_numTaggedFields;
            ++_size;
            _arraySize = 0;
            _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.finalizedFeatures.size() + 1));
            iterator = this.finalizedFeatures.iterator();
            while (iterator.hasNext()) {
                FinalizedFeatureKey finalizedFeaturesElement = (FinalizedFeatureKey)iterator.next();
                _arraySize += finalizedFeaturesElement.size(_cache, _version);
            }
            _cache.setArraySizeInBytes((Object)this.finalizedFeatures, _arraySize);
            _size += _arraySize + ByteUtils.sizeOfUnsignedVarint((int)_arraySize);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 3) {
            _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApiVersionsResponseData)) {
            return false;
        }
        ApiVersionsResponseData other = (ApiVersionsResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.apiKeys == null ? other.apiKeys != null : !this.apiKeys.equals((Object)other.apiKeys)) {
            return false;
        }
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.supportedFeatures == null ? other.supportedFeatures != null : !this.supportedFeatures.equals((Object)other.supportedFeatures)) {
            return false;
        }
        if (this.finalizedFeaturesEpoch != other.finalizedFeaturesEpoch) {
            return false;
        }
        if (this.finalizedFeatures == null ? other.finalizedFeatures != null : !this.finalizedFeatures.equals((Object)other.finalizedFeatures)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.apiKeys == null ? 0 : this.apiKeys.hashCode());
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.supportedFeatures == null ? 0 : this.supportedFeatures.hashCode());
        hashCode = 31 * hashCode + ((int)(this.finalizedFeaturesEpoch >> 32) ^ (int)this.finalizedFeaturesEpoch);
        hashCode = 31 * hashCode + (this.finalizedFeatures == null ? 0 : this.finalizedFeatures.hashCode());
        return hashCode;
    }

    public ApiVersionsResponseData duplicate() {
        Object _element;
        ApiVersionsResponseData _duplicate = new ApiVersionsResponseData();
        _duplicate.errorCode = this.errorCode;
        ApiVersionsResponseKeyCollection newApiKeys = new ApiVersionsResponseKeyCollection(this.apiKeys.size());
        Iterator iterator = this.apiKeys.iterator();
        while (iterator.hasNext()) {
            _element = (ApiVersionsResponseKey)iterator.next();
            newApiKeys.add(((ApiVersionsResponseKey)_element).duplicate());
        }
        _duplicate.apiKeys = newApiKeys;
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        SupportedFeatureKeyCollection newSupportedFeatures = new SupportedFeatureKeyCollection(this.supportedFeatures.size());
        _element = this.supportedFeatures.iterator();
        while (_element.hasNext()) {
            SupportedFeatureKey _element2 = (SupportedFeatureKey)_element.next();
            newSupportedFeatures.add(_element2.duplicate());
        }
        _duplicate.supportedFeatures = newSupportedFeatures;
        _duplicate.finalizedFeaturesEpoch = this.finalizedFeaturesEpoch;
        FinalizedFeatureKeyCollection newFinalizedFeatures = new FinalizedFeatureKeyCollection(this.finalizedFeatures.size());
        Iterator iterator2 = this.finalizedFeatures.iterator();
        while (iterator2.hasNext()) {
            FinalizedFeatureKey _element3 = (FinalizedFeatureKey)iterator2.next();
            newFinalizedFeatures.add(_element3.duplicate());
        }
        _duplicate.finalizedFeatures = newFinalizedFeatures;
        return _duplicate;
    }

    public String toString() {
        return "ApiVersionsResponseData(errorCode=" + this.errorCode + ", apiKeys=" + MessageUtil.deepToString((Iterator)this.apiKeys.iterator()) + ", throttleTimeMs=" + this.throttleTimeMs + ", supportedFeatures=" + MessageUtil.deepToString((Iterator)this.supportedFeatures.iterator()) + ", finalizedFeaturesEpoch=" + this.finalizedFeaturesEpoch + ", finalizedFeatures=" + MessageUtil.deepToString((Iterator)this.finalizedFeatures.iterator()) + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public ApiVersionsResponseKeyCollection apiKeys() {
        return this.apiKeys;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public SupportedFeatureKeyCollection supportedFeatures() {
        return this.supportedFeatures;
    }

    public long finalizedFeaturesEpoch() {
        return this.finalizedFeaturesEpoch;
    }

    public FinalizedFeatureKeyCollection finalizedFeatures() {
        return this.finalizedFeatures;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ApiVersionsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ApiVersionsResponseData setApiKeys(ApiVersionsResponseKeyCollection v) {
        this.apiKeys = v;
        return this;
    }

    public ApiVersionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ApiVersionsResponseData setSupportedFeatures(SupportedFeatureKeyCollection v) {
        this.supportedFeatures = v;
        return this;
    }

    public ApiVersionsResponseData setFinalizedFeaturesEpoch(long v) {
        this.finalizedFeaturesEpoch = v;
        return this;
    }

    public ApiVersionsResponseData setFinalizedFeatures(FinalizedFeatureKeyCollection v) {
        this.finalizedFeatures = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The top-level error code."), new Field("api_keys", (Type)new ArrayOf((Type)ApiVersionsResponseKey.SCHEMA_0), "The APIs supported by the broker."), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")});
        SCHEMA_3 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The top-level error code."), new Field("api_keys", (Type)new CompactArrayOf((Type)ApiVersionsResponseKey.SCHEMA_3), "The APIs supported by the broker."), new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("supported_features", (Type)new CompactArrayOf((Type)SupportedFeatureKey.SCHEMA_3), "Features supported by the broker."), 1, new Field("finalized_features_epoch", (Type)Type.INT64, "The monotonically increasing epoch for the finalized features information. Valid values are >= 0. A value of -1 is special and represents unknown epoch."), 2, new Field("finalized_features", (Type)new CompactArrayOf((Type)FinalizedFeatureKey.SCHEMA_3), "List of cluster-wide finalized features. The information is valid only if FinalizedFeaturesEpoch >= 0.")})});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class FinalizedFeatureKeyCollection
    extends ImplicitLinkedHashMultiCollection<FinalizedFeatureKey> {
        public FinalizedFeatureKeyCollection() {
        }

        public FinalizedFeatureKeyCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public FinalizedFeatureKeyCollection(Iterator<FinalizedFeatureKey> iterator) {
            super(iterator);
        }

        public FinalizedFeatureKey find(String name) {
            FinalizedFeatureKey _key = new FinalizedFeatureKey();
            _key.setName(name);
            return (FinalizedFeatureKey)this.find(_key);
        }

        public List<FinalizedFeatureKey> findAll(String name) {
            FinalizedFeatureKey _key = new FinalizedFeatureKey();
            _key.setName(name);
            return this.findAll(_key);
        }

        public FinalizedFeatureKeyCollection duplicate() {
            FinalizedFeatureKeyCollection _duplicate = new FinalizedFeatureKeyCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                FinalizedFeatureKey _element = (FinalizedFeatureKey)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class FinalizedFeatureKey
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        short maxVersionLevel;
        short minVersionLevel;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_3 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The name of the feature."), new Field("max_version_level", (Type)Type.INT16, "The cluster-wide finalized max version level for the feature."), new Field("min_version_level", (Type)Type.INT16, "The cluster-wide finalized min version level for the feature."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, SCHEMA_3};
        public static final short LOWEST_SUPPORTED_VERSION = 3;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public FinalizedFeatureKey(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public FinalizedFeatureKey(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public FinalizedFeatureKey() {
            this.name = "";
            this.maxVersionLevel = 0;
            this.minVersionLevel = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FinalizedFeatureKey");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.maxVersionLevel = _readable.readShort();
            this.minVersionLevel = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FinalizedFeatureKey");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.maxVersionLevel);
            _writable.writeShort(this.minVersionLevel);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FinalizedFeatureKey");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.name = struct.getString("name");
            this.maxVersionLevel = struct.getShort("max_version_level");
            this.minVersionLevel = struct.getShort("min_version_level");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of FinalizedFeatureKey");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("max_version_level", (Object)this.maxVersionLevel);
            struct.set("min_version_level", (Object)this.minVersionLevel);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FinalizedFeatureKey");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size += 2;
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof FinalizedFeatureKey)) {
                return false;
            }
            FinalizedFeatureKey other = (FinalizedFeatureKey)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FinalizedFeatureKey)) {
                return false;
            }
            FinalizedFeatureKey other = (FinalizedFeatureKey)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.maxVersionLevel != other.maxVersionLevel) {
                return false;
            }
            if (this.minVersionLevel != other.minVersionLevel) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public FinalizedFeatureKey duplicate() {
            FinalizedFeatureKey _duplicate = new FinalizedFeatureKey();
            _duplicate.name = this.name;
            _duplicate.maxVersionLevel = this.maxVersionLevel;
            _duplicate.minVersionLevel = this.minVersionLevel;
            return _duplicate;
        }

        public String toString() {
            return "FinalizedFeatureKey(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", maxVersionLevel=" + this.maxVersionLevel + ", minVersionLevel=" + this.minVersionLevel + ")";
        }

        public String name() {
            return this.name;
        }

        public short maxVersionLevel() {
            return this.maxVersionLevel;
        }

        public short minVersionLevel() {
            return this.minVersionLevel;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FinalizedFeatureKey setName(String v) {
            this.name = v;
            return this;
        }

        public FinalizedFeatureKey setMaxVersionLevel(short v) {
            this.maxVersionLevel = v;
            return this;
        }

        public FinalizedFeatureKey setMinVersionLevel(short v) {
            this.minVersionLevel = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class SupportedFeatureKeyCollection
    extends ImplicitLinkedHashMultiCollection<SupportedFeatureKey> {
        public SupportedFeatureKeyCollection() {
        }

        public SupportedFeatureKeyCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public SupportedFeatureKeyCollection(Iterator<SupportedFeatureKey> iterator) {
            super(iterator);
        }

        public SupportedFeatureKey find(String name) {
            SupportedFeatureKey _key = new SupportedFeatureKey();
            _key.setName(name);
            return (SupportedFeatureKey)this.find(_key);
        }

        public List<SupportedFeatureKey> findAll(String name) {
            SupportedFeatureKey _key = new SupportedFeatureKey();
            _key.setName(name);
            return this.findAll(_key);
        }

        public SupportedFeatureKeyCollection duplicate() {
            SupportedFeatureKeyCollection _duplicate = new SupportedFeatureKeyCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                SupportedFeatureKey _element = (SupportedFeatureKey)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class SupportedFeatureKey
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        short minVersion;
        short maxVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_3 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The name of the feature."), new Field("min_version", (Type)Type.INT16, "The minimum supported version for the feature."), new Field("max_version", (Type)Type.INT16, "The maximum supported version for the feature."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, SCHEMA_3};
        public static final short LOWEST_SUPPORTED_VERSION = 3;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public SupportedFeatureKey(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public SupportedFeatureKey(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public SupportedFeatureKey() {
            this.name = "";
            this.minVersion = 0;
            this.maxVersion = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of SupportedFeatureKey");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.minVersion = _readable.readShort();
            this.maxVersion = _readable.readShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of SupportedFeatureKey");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.minVersion);
            _writable.writeShort(this.maxVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of SupportedFeatureKey");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.name = struct.getString("name");
            this.minVersion = struct.getShort("min_version");
            this.maxVersion = struct.getShort("max_version");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of SupportedFeatureKey");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("min_version", (Object)this.minVersion);
            struct.set("max_version", (Object)this.maxVersion);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of SupportedFeatureKey");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            _size += 2;
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof SupportedFeatureKey)) {
                return false;
            }
            SupportedFeatureKey other = (SupportedFeatureKey)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SupportedFeatureKey)) {
                return false;
            }
            SupportedFeatureKey other = (SupportedFeatureKey)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.minVersion != other.minVersion) {
                return false;
            }
            if (this.maxVersion != other.maxVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public SupportedFeatureKey duplicate() {
            SupportedFeatureKey _duplicate = new SupportedFeatureKey();
            _duplicate.name = this.name;
            _duplicate.minVersion = this.minVersion;
            _duplicate.maxVersion = this.maxVersion;
            return _duplicate;
        }

        public String toString() {
            return "SupportedFeatureKey(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", minVersion=" + this.minVersion + ", maxVersion=" + this.maxVersion + ")";
        }

        public String name() {
            return this.name;
        }

        public short minVersion() {
            return this.minVersion;
        }

        public short maxVersion() {
            return this.maxVersion;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public SupportedFeatureKey setName(String v) {
            this.name = v;
            return this;
        }

        public SupportedFeatureKey setMinVersion(short v) {
            this.minVersion = v;
            return this;
        }

        public SupportedFeatureKey setMaxVersion(short v) {
            this.maxVersion = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }

    public static class ApiVersionsResponseKeyCollection
    extends ImplicitLinkedHashMultiCollection<ApiVersionsResponseKey> {
        public ApiVersionsResponseKeyCollection() {
        }

        public ApiVersionsResponseKeyCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public ApiVersionsResponseKeyCollection(Iterator<ApiVersionsResponseKey> iterator) {
            super(iterator);
        }

        public ApiVersionsResponseKey find(short apiKey) {
            ApiVersionsResponseKey _key = new ApiVersionsResponseKey();
            _key.setApiKey(apiKey);
            return (ApiVersionsResponseKey)this.find(_key);
        }

        public List<ApiVersionsResponseKey> findAll(short apiKey) {
            ApiVersionsResponseKey _key = new ApiVersionsResponseKey();
            _key.setApiKey(apiKey);
            return this.findAll(_key);
        }

        public ApiVersionsResponseKeyCollection duplicate() {
            ApiVersionsResponseKeyCollection _duplicate = new ApiVersionsResponseKeyCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ApiVersionsResponseKey _element = (ApiVersionsResponseKey)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class ApiVersionsResponseKey
    implements Message,
    ImplicitLinkedHashCollection.Element {
        short apiKey;
        short minVersion;
        short maxVersion;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public ApiVersionsResponseKey(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public ApiVersionsResponseKey(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public ApiVersionsResponseKey() {
            this.apiKey = 0;
            this.minVersion = 0;
            this.maxVersion = 0;
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 3;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ApiVersionsResponseKey");
            }
            this.apiKey = _readable.readShort();
            this.minVersion = _readable.readShort();
            this.maxVersion = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.apiKey);
            _writable.writeShort(this.minVersion);
            _writable.writeShort(this.maxVersion);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 3) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ApiVersionsResponseKey");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 3) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.apiKey = struct.getShort("api_key");
            this.minVersion = struct.getShort("min_version");
            this.maxVersion = struct.getShort("max_version");
            if (_version >= 3 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ApiVersionsResponseKey");
            }
            TreeMap _taggedFields = null;
            if (_version >= 3) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("api_key", (Object)this.apiKey);
            struct.set("min_version", (Object)this.minVersion);
            struct.set("max_version", (Object)this.maxVersion);
            if (_version >= 3) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ApiVersionsResponseKey");
            }
            _size += 2;
            _size += 2;
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 3) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof ApiVersionsResponseKey)) {
                return false;
            }
            ApiVersionsResponseKey other = (ApiVersionsResponseKey)obj;
            return this.apiKey == other.apiKey;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ApiVersionsResponseKey)) {
                return false;
            }
            ApiVersionsResponseKey other = (ApiVersionsResponseKey)obj;
            if (this.apiKey != other.apiKey) {
                return false;
            }
            if (this.minVersion != other.minVersion) {
                return false;
            }
            if (this.maxVersion != other.maxVersion) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.apiKey;
            return hashCode;
        }

        public ApiVersionsResponseKey duplicate() {
            ApiVersionsResponseKey _duplicate = new ApiVersionsResponseKey();
            _duplicate.apiKey = this.apiKey;
            _duplicate.minVersion = this.minVersion;
            _duplicate.maxVersion = this.maxVersion;
            return _duplicate;
        }

        public String toString() {
            return "ApiVersionsResponseKey(apiKey=" + this.apiKey + ", minVersion=" + this.minVersion + ", maxVersion=" + this.maxVersion + ")";
        }

        public short apiKey() {
            return this.apiKey;
        }

        public short minVersion() {
            return this.minVersion;
        }

        public short maxVersion() {
            return this.maxVersion;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ApiVersionsResponseKey setApiKey(short v) {
            this.apiKey = v;
            return this;
        }

        public ApiVersionsResponseKey setMinVersion(short v) {
            this.minVersion = v;
            return this;
        }

        public ApiVersionsResponseKey setMaxVersion(short v) {
            this.maxVersion = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("api_key", (Type)Type.INT16, "The API index."), new Field("min_version", (Type)Type.INT16, "The minimum supported version, inclusive."), new Field("max_version", (Type)Type.INT16, "The maximum supported version, inclusive.")}));
            SCHEMA_3 = new Schema(new Field[]{new Field("api_key", (Type)Type.INT16, "The API index."), new Field("min_version", (Type)Type.INT16, "The minimum supported version, inclusive."), new Field("max_version", (Type)Type.INT16, "The maximum supported version, inclusive."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

