/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class AlterUserScramCredentialsRequestData
implements ApiMessage {
    List<ScramCredentialDeletion> deletions;
    List<ScramCredentialUpsertion> upsertions;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("deletions", (Type)new CompactArrayOf((Type)ScramCredentialDeletion.SCHEMA_0), "The SCRAM credentials to remove."), new Field("upsertions", (Type)new CompactArrayOf((Type)ScramCredentialUpsertion.SCHEMA_0), "The SCRAM credentials to update/insert."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterUserScramCredentialsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AlterUserScramCredentialsRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public AlterUserScramCredentialsRequestData() {
        this.deletions = new ArrayList<ScramCredentialDeletion>(0);
        this.upsertions = new ArrayList<ScramCredentialUpsertion>(0);
    }

    public short apiKey() {
        return 51;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        int i;
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field deletions was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<ScramCredentialDeletion> newCollection = new ArrayList<ScramCredentialDeletion>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new ScramCredentialDeletion(_readable, _version));
        }
        this.deletions = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field upsertions was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((ScramCredentialDeletion)((Object)new ScramCredentialUpsertion(_readable, _version)));
        }
        this.upsertions = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.deletions.size() + 1);
        for (ScramCredentialDeletion deletionsElement : this.deletions) {
            deletionsElement.write(_writable, _cache, _version);
        }
        _writable.writeUnsignedVarint(this.upsertions.size() + 1);
        for (ScramCredentialUpsertion upsertionsElement : this.upsertions) {
            upsertionsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        Object[] _nestedObjects = struct.getArray("deletions");
        this.deletions = new ArrayList<ScramCredentialDeletion>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.deletions.add(new ScramCredentialDeletion((Struct)nestedObject, _version));
        }
        _nestedObjects = struct.getArray("upsertions");
        this.upsertions = new ArrayList<ScramCredentialUpsertion>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.upsertions.add(new ScramCredentialUpsertion((Struct)nestedObject, _version));
        }
        if (!_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        _taggedFields = new TreeMap();
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.deletions.size()];
        int i = 0;
        for (ScramCredentialDeletion scramCredentialDeletion : this.deletions) {
            _nestedObjects[i++] = scramCredentialDeletion.toStruct(_version);
        }
        struct.set("deletions", (Object)_nestedObjects);
        _nestedObjects = new Struct[this.upsertions.size()];
        i = 0;
        for (ScramCredentialUpsertion scramCredentialUpsertion : this.upsertions) {
            _nestedObjects[i++] = scramCredentialUpsertion.toStruct(_version);
        }
        struct.set("upsertions", (Object)_nestedObjects);
        struct.set("_tagged_fields", _taggedFields);
        return struct;
    }

    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.deletions.size() + 1));
        for (ScramCredentialDeletion deletionsElement : this.deletions) {
            _arraySize += deletionsElement.size(_cache, _version);
        }
        _size += _arraySize;
        _arraySize = 0;
        _arraySize += ByteUtils.sizeOfUnsignedVarint((int)(this.upsertions.size() + 1));
        for (ScramCredentialUpsertion upsertionsElement : this.upsertions) {
            _arraySize += upsertionsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                _size += _field.size();
            }
        }
        return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterUserScramCredentialsRequestData)) {
            return false;
        }
        AlterUserScramCredentialsRequestData other = (AlterUserScramCredentialsRequestData)obj;
        if (this.deletions == null ? other.deletions != null : !this.deletions.equals(other.deletions)) {
            return false;
        }
        if (this.upsertions == null ? other.upsertions != null : !this.upsertions.equals(other.upsertions)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.deletions == null ? 0 : this.deletions.hashCode());
        hashCode = 31 * hashCode + (this.upsertions == null ? 0 : this.upsertions.hashCode());
        return hashCode;
    }

    public AlterUserScramCredentialsRequestData duplicate() {
        AlterUserScramCredentialsRequestData _duplicate = new AlterUserScramCredentialsRequestData();
        ArrayList<ScramCredentialDeletion> newDeletions = new ArrayList<ScramCredentialDeletion>(this.deletions.size());
        for (ScramCredentialDeletion _element : this.deletions) {
            newDeletions.add(_element.duplicate());
        }
        _duplicate.deletions = newDeletions;
        ArrayList<ScramCredentialUpsertion> newUpsertions = new ArrayList<ScramCredentialUpsertion>(this.upsertions.size());
        for (ScramCredentialUpsertion _element : this.upsertions) {
            newUpsertions.add(_element.duplicate());
        }
        _duplicate.upsertions = newUpsertions;
        return _duplicate;
    }

    public String toString() {
        return "AlterUserScramCredentialsRequestData(deletions=" + MessageUtil.deepToString(this.deletions.iterator()) + ", upsertions=" + MessageUtil.deepToString(this.upsertions.iterator()) + ")";
    }

    public List<ScramCredentialDeletion> deletions() {
        return this.deletions;
    }

    public List<ScramCredentialUpsertion> upsertions() {
        return this.upsertions;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterUserScramCredentialsRequestData setDeletions(List<ScramCredentialDeletion> v) {
        this.deletions = v;
        return this;
    }

    public AlterUserScramCredentialsRequestData setUpsertions(List<ScramCredentialUpsertion> v) {
        this.upsertions = v;
        return this;
    }

    public static class ScramCredentialUpsertion
    implements Message {
        String name;
        byte mechanism;
        int iterations;
        byte[] salt;
        byte[] saltedPassword;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The user name."), new Field("mechanism", (Type)Type.INT8, "The SCRAM mechanism."), new Field("iterations", (Type)Type.INT32, "The number of iterations."), new Field("salt", (Type)Type.COMPACT_BYTES, "A random salt generated by the client."), new Field("salted_password", (Type)Type.COMPACT_BYTES, "The salted password."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ScramCredentialUpsertion(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ScramCredentialUpsertion(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ScramCredentialUpsertion() {
            this.name = "";
            this.mechanism = 0;
            this.iterations = 0;
            this.salt = Bytes.EMPTY;
            this.saltedPassword = Bytes.EMPTY;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ScramCredentialUpsertion");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.mechanism = _readable.readByte();
            this.iterations = _readable.readInt();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field salt was serialized as null");
            }
            byte[] newBytes = _readable.readArray(length);
            this.salt = newBytes;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field saltedPassword was serialized as null");
            }
            newBytes = _readable.readArray(length);
            this.saltedPassword = newBytes;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.mechanism);
            _writable.writeInt(this.iterations);
            _writable.writeUnsignedVarint(this.salt.length + 1);
            _writable.writeByteArray(this.salt);
            _writable.writeUnsignedVarint(this.saltedPassword.length + 1);
            _writable.writeByteArray(this.saltedPassword);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ScramCredentialUpsertion");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.name = struct.getString("name");
            this.mechanism = struct.getByte("mechanism");
            this.iterations = struct.getInt("iterations");
            this.salt = struct.getByteArray("salt");
            this.saltedPassword = struct.getByteArray("salted_password");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ScramCredentialUpsertion");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("mechanism", (Object)this.mechanism);
            struct.set("iterations", (Object)this.iterations);
            struct.setByteArray("salt", this.salt);
            struct.setByteArray("salted_password", this.saltedPassword);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ScramCredentialUpsertion");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            ++_size;
            _size += 4;
            int _bytesSize = this.salt.length;
            _size += (_bytesSize += ByteUtils.sizeOfUnsignedVarint((int)(this.salt.length + 1)));
            _bytesSize = this.saltedPassword.length;
            _size += (_bytesSize += ByteUtils.sizeOfUnsignedVarint((int)(this.saltedPassword.length + 1)));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ScramCredentialUpsertion)) {
                return false;
            }
            ScramCredentialUpsertion other = (ScramCredentialUpsertion)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.mechanism != other.mechanism) {
                return false;
            }
            if (this.iterations != other.iterations) {
                return false;
            }
            if (!Arrays.equals(this.salt, other.salt)) {
                return false;
            }
            if (!Arrays.equals(this.saltedPassword, other.saltedPassword)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.mechanism;
            hashCode = 31 * hashCode + this.iterations;
            hashCode = 31 * hashCode + Arrays.hashCode(this.salt);
            hashCode = 31 * hashCode + Arrays.hashCode(this.saltedPassword);
            return hashCode;
        }

        public ScramCredentialUpsertion duplicate() {
            ScramCredentialUpsertion _duplicate = new ScramCredentialUpsertion();
            _duplicate.name = this.name;
            _duplicate.mechanism = this.mechanism;
            _duplicate.iterations = this.iterations;
            _duplicate.salt = MessageUtil.duplicate((byte[])this.salt);
            _duplicate.saltedPassword = MessageUtil.duplicate((byte[])this.saltedPassword);
            return _duplicate;
        }

        public String toString() {
            return "ScramCredentialUpsertion(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", mechanism=" + this.mechanism + ", iterations=" + this.iterations + ", salt=" + Arrays.toString(this.salt) + ", saltedPassword=" + Arrays.toString(this.saltedPassword) + ")";
        }

        public String name() {
            return this.name;
        }

        public byte mechanism() {
            return this.mechanism;
        }

        public int iterations() {
            return this.iterations;
        }

        public byte[] salt() {
            return this.salt;
        }

        public byte[] saltedPassword() {
            return this.saltedPassword;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ScramCredentialUpsertion setName(String v) {
            this.name = v;
            return this;
        }

        public ScramCredentialUpsertion setMechanism(byte v) {
            this.mechanism = v;
            return this;
        }

        public ScramCredentialUpsertion setIterations(int v) {
            this.iterations = v;
            return this;
        }

        public ScramCredentialUpsertion setSalt(byte[] v) {
            this.salt = v;
            return this;
        }

        public ScramCredentialUpsertion setSaltedPassword(byte[] v) {
            this.saltedPassword = v;
            return this;
        }
    }

    public static class ScramCredentialDeletion
    implements Message {
        String name;
        byte mechanism;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The user name."), new Field("mechanism", (Type)Type.INT8, "The SCRAM mechanism."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ScramCredentialDeletion(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ScramCredentialDeletion(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ScramCredentialDeletion() {
            this.name = "";
            this.mechanism = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ScramCredentialDeletion");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.mechanism = _readable.readByte();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.mechanism);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ScramCredentialDeletion");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.name = struct.getString("name");
            this.mechanism = struct.getByte("mechanism");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ScramCredentialDeletion");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("mechanism", (Object)this.mechanism);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ScramCredentialDeletion");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1));
            ++_size;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint((int)_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ScramCredentialDeletion)) {
                return false;
            }
            ScramCredentialDeletion other = (ScramCredentialDeletion)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.mechanism != other.mechanism) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.mechanism;
            return hashCode;
        }

        public ScramCredentialDeletion duplicate() {
            ScramCredentialDeletion _duplicate = new ScramCredentialDeletion();
            _duplicate.name = this.name;
            _duplicate.mechanism = this.mechanism;
            return _duplicate;
        }

        public String toString() {
            return "ScramCredentialDeletion(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", mechanism=" + this.mechanism + ")";
        }

        public String name() {
            return this.name;
        }

        public byte mechanism() {
            return this.mechanism;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ScramCredentialDeletion setName(String v) {
            this.name = v;
            return this;
        }

        public ScramCredentialDeletion setMechanism(byte v) {
            this.mechanism = v;
            return this;
        }
    }
}

