/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import org.apache.kafka.common.Node;

public class PartitionInfo {
    private final String topic;
    private final int partition;
    private final Node leader;
    private final Node[] replicas;
    private final Node[] inSyncReplicas;
    private final Node[] offlineReplicas;

    public PartitionInfo(String topic, int partition, Node leader, Node[] replicas, Node[] inSyncReplicas) {
        this(topic, partition, leader, replicas, inSyncReplicas, new Node[0]);
    }

    public PartitionInfo(String topic, int partition, Node leader, Node[] replicas, Node[] inSyncReplicas, Node[] offlineReplicas) {
        this.topic = topic;
        this.partition = partition;
        this.leader = leader;
        this.replicas = replicas;
        this.inSyncReplicas = inSyncReplicas;
        this.offlineReplicas = offlineReplicas;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public Node leader() {
        return this.leader;
    }

    public Node[] replicas() {
        return this.replicas;
    }

    public Node[] inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public Node[] offlineReplicas() {
        return this.offlineReplicas;
    }

    public String toString() {
        return String.format("Partition(topic = %s, partition = %d, leader = %s, replicas = %s, isr = %s, offlineReplicas = %s)", this.topic, this.partition, this.leader == null ? "none" : this.leader.idString(), this.formatNodeIds(this.replicas), this.formatNodeIds(this.inSyncReplicas), this.formatNodeIds(this.offlineReplicas));
    }

    private String formatNodeIds(Node[] nodes) {
        StringBuilder b = new StringBuilder("[");
        for (int i = 0; i < nodes.length; ++i) {
            b.append(nodes[i].idString());
            if (i >= nodes.length - 1) continue;
            b.append(',');
        }
        b.append("]");
        return b.toString();
    }
}

