/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.utils.CollectionUtils;
import org.apache.kafka.common.utils.Utils;

public class ListOffsetRequest
extends AbstractRequest {
    public static final long EARLIEST_TIMESTAMP = -2L;
    public static final long LATEST_TIMESTAMP = -1L;
    public static final int CONSUMER_REPLICA_ID = -1;
    public static final int DEBUGGING_REPLICA_ID = -2;
    private static final String REPLICA_ID_KEY_NAME = "replica_id";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String TIMESTAMP_KEY_NAME = "timestamp";
    private static final String MAX_NUM_OFFSETS_KEY_NAME = "max_num_offsets";
    private final int replicaId;
    private final Map<TopicPartition, PartitionData> offsetData;
    private final Map<TopicPartition, Long> partitionTimestamps;
    private final Set<TopicPartition> duplicatePartitions;

    private ListOffsetRequest(int replicaId, Map<TopicPartition, ?> targetTimes, short version) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.LIST_OFFSETS.id, version)), version);
        Map<String, Map<Integer, ?>> topicsData = CollectionUtils.groupDataByTopic(targetTimes);
        this.struct.set(REPLICA_ID_KEY_NAME, (Object)replicaId);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, ?>> topicEntry : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(TOPICS_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, ?> partitionEntry : topicEntry.getValue().entrySet()) {
                Struct partitionData;
                if (version == 0) {
                    PartitionData offsetPartitionData = (PartitionData)partitionEntry.getValue();
                    partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                    partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                    partitionData.set(TIMESTAMP_KEY_NAME, (Object)offsetPartitionData.timestamp);
                    partitionData.set(MAX_NUM_OFFSETS_KEY_NAME, (Object)offsetPartitionData.maxNumOffsets);
                    partitionArray.add(partitionData);
                    continue;
                }
                Long timestamp = (Long)partitionEntry.getValue();
                partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(TIMESTAMP_KEY_NAME, (Object)timestamp);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
        this.replicaId = replicaId;
        this.offsetData = version == 0 ? targetTimes : null;
        this.partitionTimestamps = version == 1 ? targetTimes : null;
        this.duplicatePartitions = Collections.emptySet();
    }

    public ListOffsetRequest(Struct struct, short versionId) {
        super(struct, versionId);
        HashSet<TopicPartition> duplicatePartitions = new HashSet<TopicPartition>();
        this.replicaId = struct.getInt(REPLICA_ID_KEY_NAME);
        this.offsetData = new HashMap<TopicPartition, PartitionData>();
        this.partitionTimestamps = new HashMap<TopicPartition, Long>();
        for (Object topicResponseObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.getInt(PARTITION_KEY_NAME);
                long timestamp = partitionResponse.getLong(TIMESTAMP_KEY_NAME);
                TopicPartition tp = new TopicPartition(topic, partition);
                if (partitionResponse.hasField(MAX_NUM_OFFSETS_KEY_NAME)) {
                    int maxNumOffsets = partitionResponse.getInt(MAX_NUM_OFFSETS_KEY_NAME);
                    PartitionData partitionData = new PartitionData(timestamp, maxNumOffsets);
                    this.offsetData.put(tp, partitionData);
                    continue;
                }
                if (this.partitionTimestamps.put(tp, timestamp) == null) continue;
                duplicatePartitions.add(tp);
            }
        }
        this.duplicatePartitions = duplicatePartitions;
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
        short versionId = this.version();
        if (versionId == 0) {
            for (Map.Entry<TopicPartition, PartitionData> entry : this.offsetData.entrySet()) {
                ListOffsetResponse.PartitionData partitionResponse = new ListOffsetResponse.PartitionData(Errors.forException(e).code(), new ArrayList<Long>());
                responseData.put(entry.getKey(), partitionResponse);
            }
        } else {
            for (Map.Entry<TopicPartition, Long> entry : this.partitionTimestamps.entrySet()) {
                ListOffsetResponse.PartitionData partitionResponse = new ListOffsetResponse.PartitionData(Errors.forException(e).code(), -1L, -1L);
                responseData.put(entry.getKey(), partitionResponse);
            }
        }
        switch (versionId) {
            case 0: 
            case 1: {
                return new ListOffsetResponse(responseData, versionId);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.LIST_OFFSETS.id)));
    }

    public int replicaId() {
        return this.replicaId;
    }

    @Deprecated
    public Map<TopicPartition, PartitionData> offsetData() {
        return this.offsetData;
    }

    public Map<TopicPartition, Long> partitionTimestamps() {
        return this.partitionTimestamps;
    }

    public Set<TopicPartition> duplicatePartitions() {
        return this.duplicatePartitions;
    }

    public static ListOffsetRequest parse(ByteBuffer buffer, int versionId) {
        return new ListOffsetRequest(ProtoUtils.parseRequest(ApiKeys.LIST_OFFSETS.id, versionId, buffer), (short)versionId);
    }

    public static ListOffsetRequest parse(ByteBuffer buffer) {
        return ListOffsetRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.LIST_OFFSETS.id));
    }

    @Deprecated
    public static final class PartitionData {
        public final long timestamp;
        public final int maxNumOffsets;

        public PartitionData(long timestamp, int maxNumOffsets) {
            this.timestamp = timestamp;
            this.maxNumOffsets = maxNumOffsets;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("{timestamp: ").append(this.timestamp).append(", maxNumOffsets: ").append(this.maxNumOffsets).append("}");
            return bld.toString();
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<ListOffsetRequest> {
        private final int replicaId;
        private Map<TopicPartition, PartitionData> offsetData = null;
        private Map<TopicPartition, Long> partitionTimestamps = null;
        private short minVersion = 0;

        public Builder() {
            this(-1);
        }

        public Builder(int replicaId) {
            super(ApiKeys.LIST_OFFSETS);
            this.replicaId = replicaId;
        }

        public Builder setOffsetData(Map<TopicPartition, PartitionData> offsetData) {
            this.offsetData = offsetData;
            return this;
        }

        public Builder setTargetTimes(Map<TopicPartition, Long> partitionTimestamps) {
            this.partitionTimestamps = partitionTimestamps;
            return this;
        }

        @Override
        public ListOffsetRequest build() {
            short version = this.version();
            if (version < this.minVersion) {
                throw new UnsupportedVersionException("Cannot create a v" + version + " ListOffsetRequest because " + "we require features supported only in " + this.minVersion + " or later.");
            }
            if (version == 0) {
                if (this.offsetData == null) {
                    if (this.partitionTimestamps == null) {
                        throw new RuntimeException("Must set partitionTimestamps or offsetData when creating a v0 ListOffsetRequest");
                    }
                    this.offsetData = new HashMap<TopicPartition, PartitionData>();
                    for (Map.Entry<TopicPartition, Long> entry : this.partitionTimestamps.entrySet()) {
                        this.offsetData.put(entry.getKey(), new PartitionData(entry.getValue(), 1));
                    }
                    this.partitionTimestamps = null;
                }
            } else {
                if (this.offsetData != null) {
                    throw new RuntimeException("Cannot create a v" + version + " ListOffsetRequest with v0 " + "PartitionData.");
                }
                if (this.partitionTimestamps == null) {
                    throw new RuntimeException("Must set partitionTimestamps when creating a v" + version + " ListOffsetRequest");
                }
            }
            Map<TopicPartition, Object> m = version == 0 ? this.offsetData : this.partitionTimestamps;
            return new ListOffsetRequest(this.replicaId, m, version);
        }

        public Builder setMinVersion(short minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=ListOffsetRequest").append(", replicaId=").append(this.replicaId);
            if (this.offsetData != null) {
                bld.append(", offsetData=").append(Utils.mkString(this.offsetData));
            }
            if (this.partitionTimestamps != null) {
                bld.append(", partitionTimestamps=").append(Utils.mkString(this.partitionTimestamps));
            }
            bld.append(", minVersion=").append(this.minVersion);
            bld.append(")");
            return bld.toString();
        }
    }
}

