/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.NonEmptyListValidator;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public abstract class HeaderFrom<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    public static final String FIELDS_FIELD = "fields";
    public static final String HEADERS_FIELD = "headers";
    public static final String OPERATION_FIELD = "operation";
    private static final String MOVE_OPERATION = "move";
    private static final String COPY_OPERATION = "copy";
    public static final String OVERVIEW_DOC = "Moves or copies fields in the key/value of a record into that record's headers. Corresponding elements of <code>fields</code> and <code>headers</code> together identify a field and the header it should be moved or copied to. Use the concrete transformation type designed for the record key (<code>" + Key.class.getName() + "</code>) or value (<code>" + Value.class.getName() + "</code>).";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("fields", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)new NonEmptyListValidator(), ConfigDef.Importance.HIGH, "Field names in the record whose values are to be copied or moved to headers.").define("headers", ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)new NonEmptyListValidator(), ConfigDef.Importance.HIGH, "Header names, in the same order as the field names listed in the fields configuration property.").define("operation", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"move", "copy"}), ConfigDef.Importance.HIGH, "Either <code>move</code> if the fields are to be moved to the headers (removed from the key/value), or <code>copy</code> if the fields are to be copied to the headers (retained in the key/value).");
    private final Cache<Schema, Schema> moveSchemaCache = new SynchronizedCache((Cache)new LRUCache(16));
    private List<String> fields;
    private List<String> headers;
    private Operation operation;

    public R apply(R record) {
        Object operatingValue = this.operatingValue(record);
        Schema operatingSchema = this.operatingSchema(record);
        if (operatingSchema == null) {
            return this.applySchemaless(record, operatingValue);
        }
        return this.applyWithSchema(record, operatingValue, operatingSchema);
    }

    public String version() {
        return AppInfoParser.getVersion();
    }

    private R applyWithSchema(R record, Object operatingValue, Schema operatingSchema) {
        Struct updatedValue;
        Schema updatedSchema;
        Headers updatedHeaders = record.headers().duplicate();
        Struct value = Requirements.requireStruct(operatingValue, "header " + (Object)((Object)this.operation));
        if (this.operation == Operation.MOVE) {
            updatedSchema = this.moveSchema(operatingSchema);
            updatedValue = new Struct(updatedSchema);
            for (Field field : updatedSchema.fields()) {
                updatedValue.put(field, value.get(field.name()));
            }
        } else {
            updatedSchema = operatingSchema;
            updatedValue = value;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            String fieldName = this.fields.get(i);
            String headerName = this.headers.get(i);
            Object fieldValue = value.schema().field(fieldName) != null ? value.get(fieldName) : null;
            Schema fieldSchema = operatingSchema.field(fieldName).schema();
            updatedHeaders.add(headerName, fieldValue, fieldSchema);
        }
        return this.newRecord(record, updatedSchema, updatedValue, (Iterable<Header>)updatedHeaders);
    }

    private Schema moveSchema(Schema operatingSchema) {
        Schema moveSchema = (Schema)this.moveSchemaCache.get((Object)operatingSchema);
        if (moveSchema == null) {
            SchemaBuilder builder = SchemaUtil.copySchemaBasics(operatingSchema, SchemaBuilder.struct());
            for (Field field : operatingSchema.fields()) {
                if (this.fields.contains(field.name())) continue;
                builder.field(field.name(), field.schema());
            }
            moveSchema = builder.build();
            this.moveSchemaCache.put((Object)operatingSchema, (Object)moveSchema);
        }
        return moveSchema;
    }

    private R applySchemaless(R record, Object operatingValue) {
        Headers updatedHeaders = record.headers().duplicate();
        Map<String, Object> value = Requirements.requireMap(operatingValue, "header " + (Object)((Object)this.operation));
        HashMap<String, Object> updatedValue = new HashMap<String, Object>(value);
        for (int i = 0; i < this.fields.size(); ++i) {
            String fieldName = this.fields.get(i);
            Object fieldValue = value.get(fieldName);
            String headerName = this.headers.get(i);
            if (this.operation == Operation.MOVE) {
                updatedValue.remove(fieldName);
            }
            updatedHeaders.add(headerName, fieldValue, null);
        }
        return this.newRecord(record, null, updatedValue, (Iterable<Header>)updatedHeaders);
    }

    protected abstract Object operatingValue(R var1);

    protected abstract Schema operatingSchema(R var1);

    protected abstract R newRecord(R var1, Schema var2, Object var3, Iterable<Header> var4);

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.fields = config.getList(FIELDS_FIELD);
        this.headers = config.getList(HEADERS_FIELD);
        if (this.headers.size() != this.fields.size()) {
            throw new ConfigException(String.format("'%s' config must have the same number of elements as '%s' config.", FIELDS_FIELD, HEADERS_FIELD));
        }
        this.operation = Operation.fromName(config.getString(OPERATION_FIELD));
    }

    public static class Value<R extends ConnectRecord<R>>
    extends HeaderFrom<R> {
        @Override
        public Object operatingValue(R record) {
            return record.value();
        }

        @Override
        protected Schema operatingSchema(R record) {
            return record.valueSchema();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue, Iterable<Header> updatedHeaders) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), updatedSchema, updatedValue, record.timestamp(), updatedHeaders);
        }
    }

    public static class Key<R extends ConnectRecord<R>>
    extends HeaderFrom<R> {
        @Override
        public Object operatingValue(R record) {
            return record.key();
        }

        @Override
        protected Schema operatingSchema(R record) {
            return record.keySchema();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue, Iterable<Header> updatedHeaders) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), updatedSchema, updatedValue, record.valueSchema(), record.value(), record.timestamp(), updatedHeaders);
        }
    }

    static enum Operation {
        MOVE("move"),
        COPY("copy");

        private final String name;

        private Operation(String name) {
            this.name = name;
        }

        static Operation fromName(String name) {
            switch (name) {
                case "move": {
                    return MOVE;
                }
                case "copy": {
                    return COPY;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return this.name;
        }
    }
}

