/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.util.TopicAdmin;

public class SharedTopicAdmin
implements AutoCloseable,
Supplier<TopicAdmin> {
    private final Map<String, Object> adminProps;
    private final AtomicReference<TopicAdmin> admin = new AtomicReference();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Function<Map<String, Object>, TopicAdmin> factory;

    public SharedTopicAdmin(Map<String, Object> adminProps) {
        this(adminProps, TopicAdmin::new);
    }

    SharedTopicAdmin(Map<String, Object> adminProps, Function<Map<String, Object>, TopicAdmin> factory) {
        this.adminProps = Objects.requireNonNull(adminProps);
        this.factory = Objects.requireNonNull(factory);
    }

    @Override
    public TopicAdmin get() {
        return this.topicAdmin();
    }

    public TopicAdmin topicAdmin() {
        return this.admin.updateAndGet(this::createAdmin);
    }

    public String bootstrapServers() {
        return this.adminProps.getOrDefault("bootstrap.servers", "<unknown>").toString();
    }

    @Override
    public void close() {
        TopicAdmin admin;
        if (this.closed.compareAndSet(false, true) && (admin = (TopicAdmin)this.admin.getAndSet(null)) != null) {
            admin.close();
        }
    }

    public String toString() {
        return "admin client for brokers at " + this.bootstrapServers();
    }

    protected TopicAdmin createAdmin(TopicAdmin existing) {
        if (this.closed.get()) {
            throw new ConnectException("The " + this + " has already been closed and cannot be used.");
        }
        if (existing != null) {
            return existing;
        }
        return this.factory.apply(this.adminProps);
    }
}

