/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.meta.inputs.Input;
import scala.meta.internal.metals.Classfile$;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.Messages$WorkspaceSymbolDependencies$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ReportContext;
import scala.meta.internal.metals.SemanticdbDefinition;
import scala.meta.internal.metals.SemanticdbDefinition$;
import scala.meta.internal.metals.WorkspaceSymbolQuery;
import scala.meta.internal.mtags.GlobalSymbolIndex;
import scala.meta.internal.mtags.Symbol;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.mtags.SymbolDefinition;
import scala.meta.internal.semanticdb.Scala;
import scala.meta.io.AbsolutePath;
import scala.meta.pc.SymbolSearchVisitor;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001B\r\u001b\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b1\u0002)\t\u000bM\u0003A\u0011\u0001+\t\u000fu\u0003!\u0019!C\u0005=\"11\u000e\u0001Q\u0001\n}Cq\u0001\u001c\u0001C\u0002\u0013%a\f\u0003\u0004n\u0001\u0001\u0006Ia\u0018\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019y\b\u0001)A\u0005a\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001\"CA\f\u0001\t\u0007I\u0011BA\r\u0011!\t\t\u0003\u0001Q\u0001\n\u0005m\u0001\"CA\u001b\u0001\t\u0007I\u0011BA\u001c\u0011!\tI\u0005\u0001Q\u0001\n\u0005e\u0002bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\tY\u0007\u0001C!\u0003[Bq!!)\u0001\t\u0003\n\u0019\u000bC\u0004\u0002*\u0002!\t%a+\t\u000f\u00055\u0006\u0001\"\u0003\u00020\n1rk\u001c:lgB\f7-Z*fCJ\u001c\u0007NV5tSR|'O\u0003\u0002\u001c9\u00051Q.\u001a;bYNT!!\b\u0010\u0002\u0011%tG/\u001a:oC2T!a\b\u0011\u0002\t5,G/\u0019\u0006\u0002C\u0005)1oY1mC\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\t9c$\u0001\u0002qG&\u0011\u0011F\n\u0002\u0014'fl'm\u001c7TK\u0006\u00148\r\u001b,jg&$xN]\u0001\no>\u00148n\u001d9bG\u0016\u0004\"\u0001L\u0018\u000e\u00035R!A\f\u0010\u0002\u0005%|\u0017B\u0001\u0019.\u00051\t%m]8mkR,\u0007+\u0019;i\u0003\u0015\tX/\u001a:z!\t\u0019D'D\u0001\u001b\u0013\t)$D\u0001\u000bX_J\\7\u000f]1dKNKXNY8m#V,'/_\u0001\u0006i>\\WM\u001c\t\u0003q\u0005k\u0011!\u000f\u0006\u0003um\nqA[:p]J\u00048M\u0003\u0002={\u0005)An\u001d95U*\u0011ahP\u0001\bK\u000ed\u0017\u000e]:f\u0015\u0005\u0001\u0015aA8sO&\u0011!)\u000f\u0002\u000e\u0007\u0006t7-\u001a7DQ\u0016\u001c7.\u001a:\u0002\u000b%tG-\u001a=\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dc\u0012!B7uC\u001e\u001c\u0018BA%G\u0005E9En\u001c2bYNKXNY8m\u0013:$W\r_\u0001\u0014g\u00064Xm\u00117bgN4\u0015\u000e\\3U_\u0012K7o\u001b\t\u0003\u00196k\u0011\u0001I\u0005\u0003\u001d\u0002\u0012qAQ8pY\u0016\fg.\u0001\u0002sGB\u00111'U\u0005\u0003%j\u0011QBU3q_J$8i\u001c8uKb$\u0018A\u0002\u001fj]&$h\b\u0006\u0004V1fS6\f\u0018\u000b\u0003-^\u0003\"a\r\u0001\t\u000b=;\u00019\u0001)\t\u000b):\u0001\u0019A\u0016\t\u000bE:\u0001\u0019\u0001\u001a\t\u000bY:\u0001\u0019A\u001c\t\u000b\r;\u0001\u0019\u0001#\t\u000b);\u0001\u0019A&\u0002\u001b\u0019\u0014x.\\,pe.\u001c\b/Y2f+\u0005y\u0006c\u00011fO6\t\u0011M\u0003\u0002cG\u0006!Q\u000f^5m\u0015\u0005!\u0017\u0001\u00026bm\u0006L!AZ1\u0003\u0013\u0005\u0013(/Y=MSN$\bC\u00015j\u001b\u0005Y\u0014B\u00016<\u0005E\u0019\u00160\u001c2pY&sgm\u001c:nCRLwN\\\u0001\u000fMJ|WnV8sWN\u0004\u0018mY3!\u000351'o\\7DY\u0006\u001c8\u000f]1uQ\u0006qaM]8n\u00072\f7o\u001d9bi\"\u0004\u0013!\u00052vM\u001a,'/\u001a3DY\u0006\u001c8\u000f]1uQV\t\u0001\u000fE\u0002aKF\u0004B\u0001\u0014:ui&\u00111\u000f\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005UdhB\u0001<{!\t9\b%D\u0001y\u0015\tI(%\u0001\u0004=e>|GOP\u0005\u0003w\u0002\na\u0001\u0015:fI\u00164\u0017BA?\u007f\u0005\u0019\u0019FO]5oO*\u00111\u0010I\u0001\u0013EV4g-\u001a:fI\u000ec\u0017m]:qCRD\u0007%\u0001\u0006bY2\u0014Vm];miN$\"!!\u0002\u0011\u000b\u0005\u001d\u0011\u0011C4\u000f\t\u0005%\u0011Q\u0002\b\u0004o\u0006-\u0011\"A\u0011\n\u0007\u0005=\u0001%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0011Q\u0003\u0002\u0004'\u0016\f(bAA\bA\u0005a!-\u001f(b[\u0016dUM\\4uQV\u0011\u00111\u0004\n\u0007\u0003;\t\u0019#a\f\u0007\r\u0005}\u0001\u0003AA\u000e\u00051a$/\u001a4j]\u0016lWM\u001c;?\u00035\u0011\u0017PT1nK2+gn\u001a;iAA!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*\r\fA\u0001\\1oO&!\u0011QFA\u0014\u0005\u0019y%M[3diB!\u0001-!\rh\u0013\r\t\u0019$\u0019\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014\u0018!C5t-&\u001c\u0018\u000e^3e+\t\tI\u0004E\u0003\u0002<\u0005\u00153&\u0004\u0002\u0002>)!\u0011qHA!\u0003\u001diW\u000f^1cY\u0016T1!a\u0011!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\niDA\u0002TKR\f!\"[:WSNLG/\u001a3!\u0003)!WMZ5oSRLwN\u001c\u000b\t\u0003\u001f\nY&a\u0018\u0002dA)A*!\u0015\u0002V%\u0019\u00111\u000b\u0011\u0003\r=\u0003H/[8o!\r)\u0015qK\u0005\u0004\u000332%\u0001E*z[\n|G\u000eR3gS:LG/[8o\u0011\u0019\tif\u0005a\u0001i\u0006\u0019\u0001o[4\t\r\u0005\u00054\u00031\u0001u\u0003!1\u0017\u000e\\3oC6,\u0007\"B\"\u0014\u0001\u0004!\u0015AE:i_VdGMV5tSR\u0004\u0016mY6bO\u0016$2aSA5\u0011\u0019\ti\u0006\u0006a\u0001i\u0006!b/[:ji^{'o[:qC\u000e,7+_7c_2$\"\"a\u001c\u0002v\u0005%\u0015QRAL!\ra\u0015\u0011O\u0005\u0004\u0003g\u0002#aA%oi\"9\u0011qO\u000bA\u0002\u0005e\u0014\u0001\u00029bi\"\u0004B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)\u0001\u0003gS2,'bAABG\u0006\u0019a.[8\n\t\u0005\u001d\u0015Q\u0010\u0002\u0005!\u0006$\b\u000e\u0003\u0004\u0002\fV\u0001\r\u0001^\u0001\u0007gfl'm\u001c7\t\u000f\u0005=U\u00031\u0001\u0002\u0012\u0006!1.\u001b8e!\rA\u00171S\u0005\u0004\u0003+[$AC*z[\n|GnS5oI\"9\u0011\u0011T\u000bA\u0002\u0005m\u0015!\u0002:b]\u001e,\u0007c\u00015\u0002\u001e&\u0019\u0011qT\u001e\u0003\u000bI\u000bgnZ3\u0002\u001dYL7/\u001b;DY\u0006\u001c8OZ5mKR1\u0011qNAS\u0003OCa!!\u0018\u0017\u0001\u0004!\bBBA1-\u0001\u0007A/A\u0006jg\u000e\u000bgnY3mY\u0016$G#A&\u0002\u001f\u0015D\b/\u00198e\u00072\f7o\u001d4jY\u0016$b!a\u001c\u00022\u0006M\u0006BBA/1\u0001\u0007A\u000f\u0003\u0004\u0002ba\u0001\r\u0001\u001e")
public class WorkspaceSearchVisitor
extends SymbolSearchVisitor {
    private final AbsolutePath workspace;
    private final WorkspaceSymbolQuery query;
    private final CancelChecker token;
    private final GlobalSymbolIndex index;
    private final boolean saveClassFileToDisk;
    private final ReportContext rc;
    private final ArrayList<SymbolInformation> fromWorkspace;
    private final ArrayList<SymbolInformation> fromClasspath;
    private final ArrayList<Tuple2<String, String>> bufferedClasspath;
    private final Comparator<SymbolInformation> byNameLength;
    private final Set<AbsolutePath> isVisited;

    private ArrayList<SymbolInformation> fromWorkspace() {
        return this.fromWorkspace;
    }

    private ArrayList<SymbolInformation> fromClasspath() {
        return this.fromClasspath;
    }

    private ArrayList<Tuple2<String, String>> bufferedClasspath() {
        return this.bufferedClasspath;
    }

    public Seq<SymbolInformation> allResults() {
        Object object;
        if (this.fromWorkspace().isEmpty()) {
            this.bufferedClasspath().forEach((Consumer<Tuple2<String, String>>)((Consumer<Tuple2>)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String pkg = (String)tuple2._1();
                    String name = (String)tuple2._2();
                    this.expandClassfile(pkg, name);
                    return;
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        this.fromWorkspace().sort(this.byNameLength());
        this.fromClasspath().sort(this.byNameLength());
        ArrayList<SymbolInformation> result = new ArrayList<SymbolInformation>();
        result.addAll(this.fromWorkspace());
        result.addAll(this.fromClasspath());
        if (!this.bufferedClasspath().isEmpty() && this.fromClasspath().isEmpty()) {
            AbsolutePath dependencies = this.workspace.resolve(Directories$.MODULE$.workspaceSymbol());
            if (!dependencies.isFile()) {
                MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dependencies).writeText(Messages$WorkspaceSymbolDependencies$.MODULE$.title());
            }
            object = BoxesRunTime.boxToBoolean((boolean)result.add(new SymbolInformation(Messages$WorkspaceSymbolDependencies$.MODULE$.title(), SymbolKind.Event, new Location(dependencies.toURI().toString(), new Range(new Position(0, 0), new Position(0, 0))))));
        } else {
            object = BoxedUnit.UNIT;
        }
        return MetalsEnrichments$.MODULE$.ListHasAsScala(result).asScala().toSeq();
    }

    private Comparator<SymbolInformation> byNameLength() {
        return this.byNameLength;
    }

    private Set<AbsolutePath> isVisited() {
        return this.isVisited;
    }

    private Option<SymbolDefinition> definition(String pkg, String filename, GlobalSymbolIndex index) {
        List list;
        String nme = Classfile$.MODULE$.name(filename);
        Symbol tpe = Symbol$.MODULE$.apply(Scala.Symbols$.MODULE$.Global(pkg, (Scala.Descriptor)new Scala.Descriptor$.Type(nme)));
        List forTpe = index.definitions(tpe);
        if (forTpe.isEmpty()) {
            Symbol term = Symbol$.MODULE$.apply(Scala.Symbols$.MODULE$.Global(pkg, (Scala.Descriptor)new Scala.Descriptor$.Term(nme)));
            list = index.definitions(term);
        } else {
            list = forTpe;
        }
        List defs = list;
        return ((LinearSeqOps)defs.sortBy((Function1 & Serializable)x$1 -> x$1.path().toURI().toString(), (Ordering)Ordering.String$.MODULE$)).headOption();
    }

    public boolean shouldVisitPackage(String pkg) {
        return true;
    }

    public int visitWorkspaceSymbol(Path path2, String symbol, SymbolKind kind, Range range) {
        Tuple2 tuple2 = Scala.DescriptorParser$.MODULE$.apply(symbol);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Scala.Descriptor desc = (Scala.Descriptor)tuple2._1();
        String owner = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)desc, (Object)owner);
        Scala.Descriptor desc2 = (Scala.Descriptor)tuple22._1();
        String owner2 = (String)tuple22._2();
        this.fromWorkspace().add(new SymbolInformation(desc2.name().value(), kind, new Location(path2.toUri().toString(), range), owner2.replace('/', '.')));
        return 1;
    }

    public int visitClassfile(String pkg, String filename) {
        if (this.fromWorkspace().isEmpty() || this.query.isClasspath()) {
            return this.expandClassfile(pkg, filename);
        }
        this.bufferedClasspath().add((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pkg), (Object)filename));
        return 1;
    }

    public boolean isCancelled() {
        return MetalsEnrichments$.MODULE$.XtensionCancelChecker(this.token).isCancelled();
    }

    private int expandClassfile(String pkg, String filename) {
        BooleanRef isHit = BooleanRef.create((boolean)false);
        this.definition(pkg, filename, this.index).withFilter((Function1 & Serializable)defn -> BoxesRunTime.boxToBoolean((boolean)WorkspaceSearchVisitor.$anonfun$expandClassfile$1(this, defn))).foreach((Function1 & Serializable)defn -> {
            WorkspaceSearchVisitor.$anonfun$expandClassfile$2(this, isHit, defn);
            return BoxedUnit.UNIT;
        });
        if (isHit.elem) {
            return 1;
        }
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$expandClassfile$1(WorkspaceSearchVisitor $this, SymbolDefinition defn) {
        return !$this.isVisited().apply((Object)defn.path());
    }

    public static final /* synthetic */ void $anonfun$expandClassfile$3(WorkspaceSearchVisitor $this, SymbolDefinition defn$1, BooleanRef isHit$1, SemanticdbDefinition semanticDefn) {
        if (MetalsEnrichments$.MODULE$.XtensionWorkspaceSymbolQuery($this.query).matches(semanticDefn.info())) {
            AbsolutePath path2 = $this.saveClassFileToDisk ? MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(defn$1.path()).toFileOnDisk($this.workspace) : defn$1.path();
            String uri = path2.toURI().toString();
            $this.fromClasspath().add(semanticDefn.toLsp(uri));
            isHit$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$expandClassfile$2(WorkspaceSearchVisitor $this, BooleanRef isHit$1, SymbolDefinition defn) {
        $this.isVisited().$plus$eq((Object)defn.path());
        Input.VirtualFile input = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(defn.path()).toInput();
        SemanticdbDefinition$.MODULE$.foreach(input, defn.dialect(), false, (Function1 & Serializable)semanticDefn -> {
            WorkspaceSearchVisitor.$anonfun$expandClassfile$3($this, defn, isHit$1, semanticDefn);
            return BoxedUnit.UNIT;
        }, $this.rc);
    }

    public WorkspaceSearchVisitor(AbsolutePath workspace, WorkspaceSymbolQuery query, CancelChecker token, GlobalSymbolIndex index, boolean saveClassFileToDisk, ReportContext rc) {
        this.workspace = workspace;
        this.query = query;
        this.token = token;
        this.index = index;
        this.saveClassFileToDisk = saveClassFileToDisk;
        this.rc = rc;
        this.fromWorkspace = new ArrayList();
        this.fromClasspath = new ArrayList();
        this.bufferedClasspath = new ArrayList();
        this.byNameLength = new Comparator<SymbolInformation>(null){

            public Comparator<SymbolInformation> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<SymbolInformation> thenComparing(Comparator<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<SymbolInformation> thenComparing(Function<? super SymbolInformation, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<SymbolInformation> thenComparing(Function<? super SymbolInformation, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<SymbolInformation> thenComparingInt(ToIntFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<SymbolInformation> thenComparingLong(ToLongFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<SymbolInformation> thenComparingDouble(ToDoubleFunction<? super SymbolInformation> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(SymbolInformation x, SymbolInformation y) {
                return Integer.compare(x.getName().length(), y.getName().length());
            }
        };
        this.isVisited = (Set)Set$.MODULE$.empty();
    }
}

