/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.builds;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SetOps;
import scala.collection.immutable.Seq;
import scala.meta.common.Convert$;
import scala.meta.inputs.Input;
import scala.meta.internal.builds.Digest;
import scala.meta.internal.io.PathIO$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.parsing.Trees$;
import scala.meta.io.AbsolutePath;
import scala.meta.package;
import scala.meta.package$;
import scala.meta.tokenizers.Tokenize$;
import scala.meta.tokens.Token;
import scala.meta.tokens.Tokens;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.Node;
import scala.xml.XML$;

public final class Digest$
implements Serializable {
    public static final Digest$ MODULE$ = new Digest$();
    private static final String version = "v5";

    public String version() {
        return version;
    }

    public boolean digestDirectory(AbsolutePath path, MessageDigest digest) {
        if (!path.isDirectory()) {
            return true;
        }
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).list().forall((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Digest$.MODULE$.digestFile(file, digest)));
    }

    public boolean digestFileBytes(AbsolutePath path, MessageDigest digest) {
        block0: {
            if (!path.isFile()) break block0;
            digest.update(path.readAllBytes());
        }
        return true;
    }

    public boolean digestFile(AbsolutePath path, MessageDigest digest) {
        boolean isXml;
        String ext = PathIO$.MODULE$.extension(path.toNIO());
        boolean isScala = ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sbt", "scala", "sc"}))).apply((Object)ext);
        boolean isGeneralJVM = ((IterableOnceOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"gradle", "groovy", "gradle.kts", "java", "kts"}))).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Digest$.$anonfun$digestFile$1(path, x$1)));
        String string = ext;
        String string2 = "xml";
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (isXml = false);
        if (isScala && path.isFile()) {
            return this.digestScala(path, digest);
        }
        if (isGeneralJVM && path.isFile()) {
            return this.digestGeneralJvm(path, digest);
        }
        if (isXml) {
            return this.digestXml(path, digest);
        }
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isBuild()) {
            return this.digestFileBytes(path, digest);
        }
        return true;
    }

    public boolean digestXml(AbsolutePath file, MessageDigest digest) {
        boolean bl;
        try {
            Elem xml = (Elem)XML$.MODULE$.loadFile(file.toNIO().toFile());
            Digest$.digestElement$1((Node)xml, digest);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])xml.text().split("\\s+")), (Function1 & Serializable)word -> {
                digest.update(word.getBytes());
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public boolean digestGeneralJvm(AbsolutePath file, MessageDigest digest) {
        boolean bl;
        try {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])MetalsEnrichments$.MODULE$.ListHasAsScala(Files.readAllLines(file.toNIO())).asScala().mkString("\n").replaceAll("//.*", "").split("\\s+")), (Function1 & Serializable)word -> {
                digest.update(word.getBytes());
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public boolean digestScala(AbsolutePath file, MessageDigest digest) {
        boolean bl;
        try {
            Input.VirtualFile input = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(file).toInput();
            Tokens tokens = package$.MODULE$.XtensionTokenizeDialectInput(package.XtensionDialectApply$.MODULE$.apply$extension(package$.MODULE$.XtensionDialectApply(Trees$.MODULE$.defaultTokenizerDialect()), (Object)input, Convert$.MODULE$.trivial())).tokenize(Tokenize$.MODULE$.scalametaTokenize()).get();
            tokens.foreach((Function1 & Serializable)x0$1 -> {
                Digest$.$anonfun$digestScala$1(digest, x0$1);
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public Digest apply(String md5, Digest.Status status, long millis) {
        return new Digest(md5, status, millis);
    }

    public Option<Tuple3<String, Digest.Status, Object>> unapply(Digest x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.md5(), (Object)x$0.status(), (Object)BoxesRunTime.boxToLong((long)x$0.millis())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Digest$.class);
    }

    public static final /* synthetic */ boolean $anonfun$digestFile$1(AbsolutePath path$1, String x$1) {
        return path$1.toString().endsWith(x$1);
    }

    public static final /* synthetic */ void $anonfun$digestXml$2(MessageDigest digest$2, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            MetaData attr = (MetaData)tuple2._1();
            attr.value().foreach((Function1 & Serializable)value -> {
                digest$2.update(value.toString().getBytes());
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final boolean digestElement$1(Node node2, MessageDigest digest$2) {
        Node node3 = node2;
        if (node3 instanceof Comment) {
            return true;
        }
        ((IterableOnceOps)node2.attributes().map((Function1 & Serializable)attr -> {
            digest$2.update(attr.key().getBytes());
            BoxedUnit x$2 = BoxedUnit.UNIT;
            return new Tuple2(attr, (Object)x$2);
        })).foreach((Function1 & Serializable)x$3 -> {
            Digest$.$anonfun$digestXml$2(digest$2, x$3);
            return BoxedUnit.UNIT;
        });
        return node2.child().forall((Function1 & Serializable)node -> BoxesRunTime.boxToBoolean((boolean)Digest$.digestElement$1(node, digest$2)));
    }

    public static final /* synthetic */ void $anonfun$digestScala$1(MessageDigest digest$4, Token x0$1) {
        Token token = x0$1;
        if (MetalsEnrichments$.MODULE$.XtensionToken(token).isWhiteSpaceOrComment()) {
            return;
        }
        ByteBuffer bytes = StandardCharsets.UTF_8.encode(token.pos().text());
        digest$4.update(token.productPrefix().getBytes());
        digest$4.update(bytes);
    }

    private Digest$() {
    }
}

