/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.serverless.workflow.utils.KogitoProcessContextResolverExtension;

public class KogitoProcessContextResolver {
    public static final String FOR_EACH_OUTPUT_VARIABLE = "_foreach_out_eval";
    public static final String FOR_EACH_PREV_ACTION_RESULT = "prevActionResult";
    private static KogitoProcessContextResolver instance = new KogitoProcessContextResolver();
    private Map<String, Function<KogitoProcessContext, Object>> methods = new HashMap<String, Function<KogitoProcessContext, Object>>();

    public static KogitoProcessContextResolver get() {
        return instance;
    }

    public KogitoProcessContextResolver() {
        this.methods.put("instanceId", k -> k.getProcessInstance().getId());
        this.methods.put("id", k -> k.getProcessInstance().getProcessId());
        this.methods.put("name", k -> k.getProcessInstance().getProcessName());
        this.methods.put("headers", k -> k.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().collect(Collectors.joining()))));
        this.methods.put(FOR_EACH_PREV_ACTION_RESULT, k -> k.getVariable(FOR_EACH_OUTPUT_VARIABLE));
        ServiceLoader.load(KogitoProcessContextResolverExtension.class).forEach(resolver -> this.methods.putAll(resolver.getKogitoProcessContextResolver()));
    }

    public Object readKey(KogitoProcessContext context, String key) {
        Function<KogitoProcessContext, Object> m = this.methods.get(key);
        if (m == null) {
            throw new IllegalArgumentException("Cannot find key " + key + " in context");
        }
        return m.apply(context);
    }
}

