/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kie.kogito.codegen.manager.BuilderManager;
import org.kie.kogito.codegen.manager.util.CodeGenManagerUtil;
import org.kie.kogito.maven.plugin.util.MojoUtil;

public abstract class AbstractKieMojo
extends AbstractMojo {
    @Parameter(property="kogito.codegen.decisions")
    protected String generateDecisions;
    @Parameter(property="kogito.codegen.partial", defaultValue="false")
    protected boolean generatePartial;
    @Parameter(property="kogito.codegen.predictions")
    protected String generatePredictions;
    @Parameter(property="kogito.codegen.processes")
    protected String generateProcesses;
    @Parameter(property="kogito.codegen.rules")
    protected String generateRules;
    @Parameter
    protected Map<String, String> properties;
    @Parameter(defaultValue="17", property="maven.compiler.release")
    protected String mavenCompilerJavaVersion;
    @Parameter(property="kogito.codegen.persistence")
    protected boolean persistence;
    @Parameter(required=true, defaultValue="${project.basedir}")
    protected File projectBaseDir;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    protected File projectBuildOutputDirectory;
    @Parameter(required=true, defaultValue="${project.build.sourceEncoding}")
    protected String projectSourceEncoding;
    @Parameter(property="kogito.jsonSchema.version", required=false)
    protected String jsonSchemaVersion;
    @Parameter(property="kogito.codegen.ondemand", defaultValue="false")
    protected boolean onDemand;
    @Parameter(property="kogito.sources.keep", defaultValue="false")
    protected boolean keepSources;
    @Parameter(required=true, defaultValue="${project}")
    protected MavenProject project;
    @Component
    protected MavenProject mavenProject;

    public void buildProject() throws MojoExecutionException {
        this.getLog().info((CharSequence)"buildProject");
        this.executionLog();
        try {
            Set<URI> projectFilesUris = MojoUtil.getProjectFiles(this.mavenProject, null);
            BuilderManager.BuildInfo buildInfo = new BuilderManager.BuildInfo(projectFilesUris, this.projectBaseDir.toPath(), this.projectBuildOutputDirectory.toPath(), this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.mavenProject.getVersion(), this.projectSourceEncoding, this.mavenCompilerJavaVersion, this.jsonSchemaVersion, this.generatePartial, this.persistence, this.onDemand, this.keepSources, this.mavenProject.getRuntimeClasspathElements(), this.discoverFramework(), this.properties);
            BuilderManager.build((BuilderManager.BuildInfo)buildInfo);
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error building project", (Exception)e);
        }
    }

    protected void executionLog() {
        this.getLog().info((CharSequence)("Compiler Java Version: " + this.mavenCompilerJavaVersion));
        this.getLog().info((CharSequence)("Compiler Source Encoding: " + this.projectSourceEncoding));
        this.getLog().info((CharSequence)("Project base directory: " + this.projectBaseDir.getAbsolutePath()));
        this.getLog().info((CharSequence)("Build output directory: " + this.projectBuildOutputDirectory));
        this.getLog().info((CharSequence)("Partial generation is enabled: " + this.generatePartial));
        this.getLog().info((CharSequence)("Json schema version: " + this.jsonSchemaVersion));
        this.getLog().info((CharSequence)"===================================");
    }

    CodeGenManagerUtil.Framework discoverFramework() {
        if (MojoUtil.hasDependency(this.mavenProject, CodeGenManagerUtil.Framework.QUARKUS)) {
            return CodeGenManagerUtil.Framework.QUARKUS;
        }
        if (MojoUtil.hasDependency(this.mavenProject, CodeGenManagerUtil.Framework.SPRING)) {
            return CodeGenManagerUtil.Framework.SPRING;
        }
        return CodeGenManagerUtil.Framework.NONE;
    }
}

