/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;

public class JsonNodeVisitor {
    public static JsonNode transformTextNode(JsonNode node, UnaryOperator<JsonNode> function) {
        return JsonNodeVisitor.transformNode(node, function, JsonNode::isTextual);
    }

    public static JsonNode transformNode(JsonNode node, UnaryOperator<JsonNode> function, Predicate<JsonNode> p) {
        if (node.isObject()) {
            ObjectNode processedDefinition = ObjectMapperFactory.get().createObjectNode();
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry jsonField = (Map.Entry)fields.next();
                processedDefinition.set((String)jsonField.getKey(), JsonNodeVisitor.transformNode((JsonNode)jsonField.getValue(), function, p));
            }
            return processedDefinition;
        }
        if (node.isArray()) {
            ArrayNode processedDefinition = ObjectMapperFactory.get().createArrayNode();
            ((ArrayNode)node).forEach(item -> processedDefinition.add(JsonNodeVisitor.transformNode(item, function, p)));
            return processedDefinition;
        }
        if (p.test(node)) {
            return (JsonNode)function.apply(node);
        }
        return node;
    }

    private JsonNodeVisitor() {
    }
}

