/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.kie.kogito.internal.process.event.KogitoObjectListener;
import org.kie.kogito.internal.process.event.KogitoObjectListenerAware;
import org.kie.kogito.jackson.utils.ListenerAwareUtils;

public class ArrayNodeListenerAware
extends ArrayNode
implements KogitoObjectListenerAware {
    private static final long serialVersionUID = 1L;
    private transient Collection<KogitoObjectListener> listeners = new CopyOnWriteArraySet<KogitoObjectListener>();

    public ArrayNodeListenerAware(JsonNodeFactory nf) {
        super(nf);
    }

    public ArrayNodeListenerAware(JsonNodeFactory nf, int capacity) {
        super(nf, capacity);
    }

    public ArrayNodeListenerAware(JsonNodeFactory nf, List<JsonNode> children) {
        super(nf, children);
    }

    public void addKogitoObjectListener(KogitoObjectListener listener) {
        this.listeners.add(listener);
    }

    protected ArrayNode _set(int index, JsonNode node) {
        this.processNode(index, super.get(index), node, () -> super._set(index, node));
        return this;
    }

    private void processNode(int index, JsonNode oldValue, JsonNode newValue, Runnable updater) {
        String propertyName = "[" + index + "]";
        this.fireEvent(propertyName, oldValue, newValue, updater);
    }

    protected ArrayNode _add(JsonNode node) {
        this.processNode(this.size(), (JsonNode)this.nullNode(), node, () -> super._add(node));
        return this;
    }

    protected ArrayNode _insert(int index, JsonNode node) {
        this.processNode(index, (JsonNode)this.nullNode(), node, () -> super._insert(index, node));
        return this;
    }

    public JsonNode remove(int index) {
        JsonNode oldValue = this.get(index);
        this.processNode(index, oldValue, (JsonNode)this.nullNode(), () -> super.remove(index));
        return oldValue;
    }

    public Collection<KogitoObjectListener> listeners() {
        return this.listeners;
    }

    public ArrayNode deepCopy() {
        ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
        Iterator iter = super.elements();
        while (iter.hasNext()) {
            nodes.add(((JsonNode)iter.next()).deepCopy());
        }
        return new ArrayNodeListenerAware(this._nodeFactory, nodes);
    }

    public void fireEvent(String propertyName, Object oldValue, Object newValue, Runnable updater) {
        super.fireEvent(propertyName, ListenerAwareUtils.handleNull(oldValue), ListenerAwareUtils.handleNull(newValue), updater);
    }
}

