/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.management;

import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.kie.kogito.Application;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.management.BaseProcessInstanceManagementResource;

@Path(value="/management/processes/")
public class ProcessInstanceManagementResource
extends BaseProcessInstanceManagementResource<Response> {
    public ProcessInstanceManagementResource() {
        this(null, null);
    }

    @Inject
    public ProcessInstanceManagementResource(Instance<Processes> processes, Application application) {
        super(() -> processes.get(), application);
    }

    protected <R> Response buildOkResponse(R body) {
        return Response.status((Response.Status)Response.Status.OK).entity(body).build();
    }

    protected Response badRequestResponse(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
    }

    protected Response notFoundResponse(String message) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message).build();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getProcesses() {
        return (Response)this.doGetProcesses();
    }

    @GET
    @Path(value="/{processId}")
    @Produces(value={"application/json"})
    public Response getProcessInfo(@PathParam(value="processId") String processId) {
        return (Response)this.doGetProcessInfo(processId);
    }

    @GET
    @Path(value="{processId}/nodes")
    @Produces(value={"application/json"})
    public Response getProcessNodes(@PathParam(value="processId") String processId) {
        return (Response)this.doGetProcessNodes(processId);
    }

    @GET
    @Path(value="{processId}/instances/{processInstanceId}/error")
    @Produces(value={"application/json"})
    public Response getInstanceInError(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return (Response)this.doGetInstanceInError(processId, processInstanceId);
    }

    @GET
    @Path(value="{processId}/instances/{processInstanceId}/nodeInstances")
    @Produces(value={"application/json"})
    public Response getWorkItemsInProcessInstance(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return (Response)this.doGetWorkItemsInProcessInstance(processId, processInstanceId);
    }

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/retrigger")
    @Produces(value={"application/json"})
    public Response retriggerInstanceInError(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return (Response)this.doRetriggerInstanceInError(processId, processInstanceId);
    }

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/skip")
    @Produces(value={"application/json"})
    public Response skipInstanceInError(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return (Response)this.doSkipInstanceInError(processId, processInstanceId);
    }

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/nodes/{nodeId}")
    @Produces(value={"application/json"})
    public Response triggerNodeInstanceId(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="nodeId") String nodeId) {
        return (Response)this.doTriggerNodeInstanceId(processId, processInstanceId, nodeId);
    }

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/nodeInstances/{nodeInstanceId}")
    @Produces(value={"application/json"})
    public Response retriggerNodeInstanceId(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="nodeInstanceId") String nodeInstanceId) {
        return (Response)this.doRetriggerNodeInstanceId(processId, processInstanceId, nodeInstanceId);
    }

    @DELETE
    @Path(value="{processId}/instances/{processInstanceId}/nodeInstances/{nodeInstanceId}")
    @Produces(value={"application/json"})
    public Response cancelNodeInstanceId(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="nodeInstanceId") String nodeInstanceId) {
        return (Response)this.doCancelNodeInstanceId(processId, processInstanceId, nodeInstanceId);
    }

    @DELETE
    @Path(value="{processId}/instances/{processInstanceId}")
    @Produces(value={"application/json"})
    public Response cancelProcessInstanceId(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return (Response)this.doCancelProcessInstanceId(processId, processInstanceId);
    }
}

