/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.Collection;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.Constrainable;
import org.jbpm.workflow.instance.WorkflowProcessParameters;
import org.kie.api.definition.process.Connection;

public class Split
extends NodeImpl
implements Constrainable {
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_AND = 1;
    public static final int TYPE_XOR = 2;
    public static final int TYPE_OR = 3;
    public static final int TYPE_XAND = 4;
    private static final long serialVersionUID = 510L;
    private int type;

    public Split() {
        this.type = 0;
    }

    public Split(int type) {
        this.type = type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public boolean isDefault(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (this.type == 3 || this.type == 2) {
            ConnectionRef ref = new ConnectionRef(connection.getUniqueId(), connection.getTo().getId(), connection.getToType());
            Collection constraints = (Collection)this.constraints.get(ref);
            if (constraints != null) {
                for (Constraint constraint : constraints) {
                    if (constraint == null) continue;
                    return constraint.isDefault();
                }
            }
            String defaultConnection = (String)this.getMetaData().get("Default");
            String connectionId = (String)connection.getMetaData().get("UniqueId");
            return connectionId.equals(defaultConnection);
        }
        throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with: " + this.getType());
    }

    @Override
    public Collection<Constraint> getConstraints(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (this.type == 3 || this.type == 2) {
            ConnectionRef ref = new ConnectionRef(connection.getUniqueId(), connection.getTo().getId(), connection.getToType());
            return (Collection)this.constraints.get(ref);
        }
        throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with: " + this.getType());
    }

    @Override
    public void setConstraint(Connection connection, Constraint constraint) {
        if (this.type == 3 || this.type == 2) {
            if (connection == null) {
                throw new IllegalArgumentException("connection is null");
            }
            if (!this.getDefaultOutgoingConnections().contains(connection)) {
                throw new IllegalArgumentException("connection is unknown:" + connection);
            }
        } else {
            throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with type:" + this.getType());
        }
        this.addConstraint(new ConnectionRef(connection.getUniqueId(), connection.getTo().getId(), connection.getToType()), constraint);
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getUniqueId() + ", " + connection.getTo().getName() + "] only accepts default incoming connection type!");
        }
        if (!this.getIncomingConnections("DROOLS_DEFAULT").isEmpty() && !WorkflowProcessParameters.WORKFLOW_PARAM_MULTIPLE_CONNECTIONS.get(this.getProcess()).booleanValue()) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getUniqueId() + ", " + connection.getTo().getName() + "] cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getUniqueId() + ", " + connection.getFrom().getName() + "] only accepts default outgoing connection type!");
        }
    }

    @Override
    public void removeOutgoingConnection(String type, Connection connection) {
        super.removeOutgoingConnection(type, connection);
        this.removeConstraint(connection);
    }

    public void removeConstraint(Connection connection) {
        ConnectionRef ref = new ConnectionRef(connection.getUniqueId(), connection.getTo().getId(), connection.getToType());
        this.internalRemoveConstraint(ref);
    }

    public void internalRemoveConstraint(ConnectionRef ref) {
        this.constraints.remove(ref);
    }
}

