/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.event.ExpressionEventTypeFilter;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.impl.ReturnValueEvaluator;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.definition.process.WorkflowElementIdentifier;

public class StartNodeFactory<T extends RuleFlowNodeContainerFactory<T, ?>>
extends NodeFactory<StartNodeFactory<T>, T> {
    public static final String METHOD_INTERRUPTING = "interrupting";
    public static final String METHOD_TRIGGER = "trigger";
    public static final String METHOD_TIMER = "timer";

    public StartNodeFactory(T nodeContainerFactory, NodeContainer nodeContainer, WorkflowElementIdentifier id) {
        super(nodeContainerFactory, nodeContainer, new StartNode(), id);
    }

    protected StartNode getStartNode() {
        return (StartNode)this.getNode();
    }

    public StartNodeFactory<T> interrupting(boolean interrupting) {
        this.getStartNode().setInterrupting(interrupting);
        return this;
    }

    public StartNodeFactory<T> trigger(String triggerEventType, List<DataAssociation> dataAssociations, ReturnValueEvaluator returnValueEvaluator) {
        ExpressionEventTypeFilter eventFilter = new ExpressionEventTypeFilter(triggerEventType, returnValueEvaluator);
        return this.trigger(eventFilter, dataAssociations);
    }

    public StartNodeFactory<T> trigger(EventTypeFilter eventTypeFilter, List<DataAssociation> dataAssociations) {
        EventTrigger trigger = new EventTrigger();
        trigger.addEventFilter(eventTypeFilter);
        dataAssociations.forEach(trigger::addInAssociation);
        this.getStartNode().addTrigger(trigger);
        return this;
    }

    public StartNodeFactory<T> trigger(String triggerEventType, List<DataAssociation> dataAssociations) {
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setCorrelationManager(((RuleFlowProcess)this.getStartNode().getProcess()).getCorrelationManager());
        eventFilter.setType(triggerEventType);
        eventFilter.setMessageRef((String)this.getNode().getMetaData().get("MessageRef"));
        return this.trigger(eventFilter, dataAssociations);
    }

    public StartNodeFactory<T> trigger(String triggerEventType, String target) {
        return this.trigger(triggerEventType, target, target);
    }

    public StartNodeFactory<T> trigger(String triggerEventType, String source, String target) {
        ArrayList<DataAssociation> dataAssociations = new ArrayList<DataAssociation>();
        if (source != null) {
            dataAssociations.add(new DataAssociation(DataDefinition.toSimpleDefinition(source), DataDefinition.toSimpleDefinition(target), null, null));
        }
        return this.trigger(triggerEventType, dataAssociations);
    }

    public StartNodeFactory<T> timer(String delay, String period, String date, int timeType) {
        Timer timer = new Timer();
        timer.setDate(date);
        timer.setDelay(delay);
        timer.setPeriod(period);
        timer.setTimeType(timeType);
        this.getStartNode().setTimer(timer);
        return this;
    }
}

