/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.impl;

import java.io.Serializable;
import java.util.UUID;

public class DataDefinition
implements Serializable {
    private static final long serialVersionUID = -1819075545956349183L;
    private String id;
    private String label;
    private String type;
    private String expression;

    public DataDefinition(String expression) {
        this.id = UUID.randomUUID().toString();
        this.label = "EXPRESSION - (" + expression + ")";
        this.type = "java.lang.Object";
        this.expression = expression;
    }

    public DataDefinition(String id, String label, String type, String expression) {
        this.id = id;
        this.label = label != null && !label.isEmpty() ? label : id;
        this.type = type != null ? type : "java.lang.Object";
        this.expression = expression;
    }

    public DataDefinition(String id, String label, String type) {
        this(id, label, type, null);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        String expr = this.hasExpression() ? ", expression=" + this.expression : "";
        return "DataSpec [id=" + this.id + ", label=" + this.label + ", type=" + this.type + expr + "]";
    }

    public static DataDefinition toExpression(String expression) {
        return new DataDefinition(expression);
    }

    public static DataDefinition toSimpleDefinition(String id) {
        if (id.contains("#{")) {
            return new DataDefinition(id);
        }
        return new DataDefinition(id, id, "java.lang.Object");
    }

    public boolean hasExpression() {
        return this.expression != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataDefinition other = (DataDefinition)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

