/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.context.swimlane.Swimlane;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.DataTypeResolver;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.actions.CancelNodeInstanceAction;
import org.jbpm.process.instance.impl.actions.SignalProcessInstanceAction;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowModelValidator;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.kogito.internal.process.runtime.KogitoNode;

public class RuleFlowProcessFactory
extends RuleFlowNodeContainerFactory<RuleFlowProcessFactory, RuleFlowProcessFactory> {
    public static final String METHOD_NAME = "name";
    public static final String METHOD_PACKAGE_NAME = "packageName";
    public static final String METHOD_DYNAMIC = "dynamic";
    public static final String METHOD_VERSION = "version";
    public static final String METHOD_TYPE = "type";
    public static final String METHOD_VISIBILITY = "visibility";
    public static final String METHOD_VALIDATE = "validate";
    public static final String METHOD_IMPORTS = "imports";
    public static final String METHOD_GLOBAL = "global";
    public static final String METHOD_VARIABLE = "variable";
    public static final String METHOD_ADD_COMPENSATION_CONTEXT = "addCompensationContext";
    public static final String METHOD_ERROR_EXCEPTION_HANDLER = "errorExceptionHandler";
    public static final String ERROR_TYPE_PREFIX = "Error-";
    public static final String MESSAGE_TYPE_PREFIX = "Message-";
    public static final String TIMER_TYPE_PREFIX = "Timer-";

    public static RuleFlowProcessFactory createProcess(String id) {
        return RuleFlowProcessFactory.createProcess(id, true);
    }

    public static RuleFlowProcessFactory createProcess(String id, boolean autoComplete) {
        return new RuleFlowProcessFactory(id, autoComplete);
    }

    protected RuleFlowProcessFactory(String id, boolean autoComplete) {
        super(null, null, new RuleFlowProcess(), (Object)id);
        this.getRuleFlowProcess().setAutoComplete(autoComplete);
    }

    @Override
    protected void setId(Object node, Object id) {
        this.getRuleFlowProcess().setId((String)id);
    }

    public RuleFlowProcessFactory expressionLanguage(String exprLanguage) {
        this.getRuleFlowProcess().setExpressionLanguage(exprLanguage);
        return this;
    }

    protected RuleFlowProcess getRuleFlowProcess() {
        return (RuleFlowProcess)this.node;
    }

    @Override
    public RuleFlowProcessFactory name(String name) {
        this.getRuleFlowProcess().setName(name);
        return this;
    }

    @Override
    public RuleFlowProcessFactory metaData(String name, Object value) {
        this.getRuleFlowProcess().setMetaData(name, value);
        return this;
    }

    public RuleFlowProcessFactory visibility(String visibility) {
        this.getRuleFlowProcess().setVisibility(visibility);
        return this;
    }

    public RuleFlowProcessFactory type(String type) {
        this.getRuleFlowProcess().setType(type);
        return this;
    }

    public RuleFlowProcessFactory dynamic(boolean dynamic) {
        this.getRuleFlowProcess().setDynamic(dynamic);
        if (dynamic) {
            this.getRuleFlowProcess().setAutoComplete(false);
        }
        return this;
    }

    public RuleFlowProcessFactory outputValidator(WorkflowModelValidator validator) {
        this.getRuleFlowProcess().setOutputValidator(validator);
        return this;
    }

    public RuleFlowProcessFactory inputValidator(WorkflowModelValidator validator) {
        this.getRuleFlowProcess().setInputValidator(validator);
        return this;
    }

    public RuleFlowProcessFactory version(String version) {
        this.getRuleFlowProcess().setVersion(version);
        return this;
    }

    public RuleFlowProcessFactory packageName(String packageName) {
        this.getRuleFlowProcess().setPackageName(packageName);
        return this;
    }

    public RuleFlowProcessFactory imports(String ... imports) {
        this.getRuleFlowProcess().addImports(Arrays.asList(imports));
        return this;
    }

    public RuleFlowProcessFactory functionImports(String ... functionImports) {
        this.getRuleFlowProcess().addFunctionImports(Arrays.asList(functionImports));
        return this;
    }

    public RuleFlowProcessFactory globals(Map<String, String> globals) {
        this.getRuleFlowProcess().setGlobals(globals);
        return this;
    }

    public RuleFlowProcessFactory global(String name, String type) {
        Map<String, String> globals = this.getRuleFlowProcess().getGlobals();
        if (globals == null) {
            globals = new HashMap<String, String>();
            this.getRuleFlowProcess().setGlobals(globals);
        }
        globals.put(name, type);
        return this;
    }

    public RuleFlowProcessFactory variable(String name, Class<?> clazz) {
        return this.variable(name, DataTypeResolver.fromClass(clazz), null);
    }

    @Override
    public RuleFlowProcessFactory variable(String name, DataType type) {
        return this.variable(name, type, null);
    }

    @Override
    public RuleFlowProcessFactory variable(String name, DataType type, Object value) {
        return this.variable(name, type, value, null, null);
    }

    @Override
    public RuleFlowProcessFactory variable(String name, DataType type, String metaDataName, Object metaDataValue) {
        return this.variable(name, type, null, metaDataName, metaDataValue);
    }

    @Override
    public RuleFlowProcessFactory variable(String name, DataType type, Object value, String metaDataName, Object metaDataValue) {
        Variable variable = new Variable();
        variable.setName(name);
        variable.setType(type);
        variable.setValue(type.verifyDataType(value) ? value : type.readValue((String)value));
        if (metaDataName != null && metaDataValue != null) {
            variable.setMetaData(metaDataName, metaDataValue);
        }
        this.getRuleFlowProcess().getVariableScope().getVariables().add(variable);
        return this;
    }

    public RuleFlowProcessFactory swimlane(String name) {
        Swimlane swimlane = new Swimlane();
        swimlane.setName(name);
        this.getRuleFlowProcess().getSwimlaneContext().addSwimlane(swimlane);
        return this;
    }

    public RuleFlowProcessFactory validate() {
        this.link();
        Object[] errors = RuleFlowProcessValidator.getInstance().validateProcess(this.getRuleFlowProcess());
        if (errors.length > 0) {
            throw new IllegalStateException("Process could not be validated !" + Arrays.toString(errors));
        }
        return this;
    }

    public RuleFlowProcessFactory link() {
        RuleFlowProcess process = this.getRuleFlowProcess();
        this.linkBoundaryEvents(process);
        this.postProcessNodes(process, process);
        return this;
    }

    @Override
    public RuleFlowProcessFactory done() {
        return this;
    }

    public RuleFlowProcess getProcess() {
        return this.getRuleFlowProcess();
    }

    protected void linkBoundaryEvents(NodeContainer nodeContainer) {
        for (Node node : nodeContainer.getNodes()) {
            String attachedTo;
            if (node instanceof CompositeNode) {
                CompositeNode compositeNode = (CompositeNode)node;
                this.linkBoundaryEvents(compositeNode.getNodeContainer());
            }
            if (!(node instanceof EventNode) || (attachedTo = (String)node.getMetaData().get("AttachedTo")) == null) continue;
            Node attachedNode = this.findNodeByIdOrUniqueIdInMetadata(nodeContainer, attachedTo, "Could not find node to attach to: " + attachedTo);
            for (EventFilter filter : ((EventNode)node).getEventFilters()) {
                String type = Optional.ofNullable(((EventTypeFilter)filter).getType()).orElse("");
                if (type.startsWith(TIMER_TYPE_PREFIX)) {
                    this.linkBoundaryTimerEvent(node, attachedTo, attachedNode);
                    continue;
                }
                if (node.getMetaData().get("SignalName") != null || type.startsWith(MESSAGE_TYPE_PREFIX)) {
                    this.linkBoundarySignalEvent(node, attachedTo);
                    continue;
                }
                if (!type.startsWith(ERROR_TYPE_PREFIX)) continue;
                this.linkBoundaryErrorEvent(node, attachedTo, attachedNode);
            }
        }
    }

    protected void linkBoundaryTimerEvent(Node node, String attachedTo, Node attachedNode) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        StateBasedNode compositeNode = (StateBasedNode)attachedNode;
        String timeDuration = (String)node.getMetaData().get("TimeDuration");
        String timeCycle = (String)node.getMetaData().get("TimeCycle");
        String timeDate = (String)node.getMetaData().get("TimeDate");
        Timer timer = new Timer();
        if (timeDuration != null) {
            timer.setDelay(timeDuration);
            timer.setTimeType(1);
            compositeNode.addTimer(timer, this.timerAction(TIMER_TYPE_PREFIX + attachedTo + "-" + timeDuration + "-" + node.getId()));
        } else if (timeCycle != null) {
            int index = timeCycle.indexOf("###");
            if (index != -1) {
                String period = timeCycle.substring(index + 3);
                timeCycle = timeCycle.substring(0, index);
                timer.setPeriod(period);
            }
            timer.setDelay(timeCycle);
            timer.setTimeType(2);
            compositeNode.addTimer(timer, this.timerAction(TIMER_TYPE_PREFIX + attachedTo + "-" + timeCycle + (String)(timer.getPeriod() == null ? "" : "###" + timer.getPeriod()) + "-" + node.getId()));
        } else if (timeDate != null) {
            timer.setDate(timeDate);
            timer.setTimeType(3);
            compositeNode.addTimer(timer, this.timerAction(TIMER_TYPE_PREFIX + attachedTo + "-" + timeDate + "-" + node.getId()));
        }
        if (cancelActivity) {
            List<DroolsAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<DroolsAction>();
            }
            DroolsConsequenceAction cancelAction = new DroolsConsequenceAction("java", null);
            cancelAction.setMetaData("Action", new CancelNodeInstanceAction(attachedTo));
            actions.add(cancelAction);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    protected void linkBoundarySignalEvent(Node node, String attachedTo) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        if (cancelActivity) {
            List<DroolsAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<DroolsAction>();
            }
            DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
            action.setMetaData("Action", new CancelNodeInstanceAction(attachedTo));
            actions.add(action);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    protected void linkBoundaryErrorEvent(Node node, String attachedTo, Node attachedNode) {
        ContextResolver compositeNode = (ContextResolver)attachedNode;
        String errorCode = (String)node.getMetaData().get("ErrorEvent");
        ExceptionScope exceptionScope = (ExceptionScope)compositeNode.resolveContext("ExceptionScope", errorCode);
        if (exceptionScope == null) {
            ContextContainer contextContainer = (ContextContainer)(node instanceof ContextContainer ? node : ((KogitoNode)node).getParentContainer());
            exceptionScope = new ExceptionScope();
            contextContainer.addContext(exceptionScope);
            contextContainer.setDefaultContext(exceptionScope);
        }
        Boolean hasErrorCode = (Boolean)node.getMetaData().get("HasErrorEvent");
        String errorStructureRef = (String)node.getMetaData().get("ErrorStructureRef");
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        EventNode eventNode = (EventNode)node;
        String variable = eventNode.getVariableName();
        String inputVariable = eventNode.getInputVariableName();
        DroolsConsequenceAction signalAction = new DroolsConsequenceAction("java", null);
        signalAction.setMetaData("Action", new SignalProcessInstanceAction(ERROR_TYPE_PREFIX + attachedTo + "-" + errorCode, variable, inputVariable, "processInstance"));
        exceptionHandler.setAction(signalAction);
        exceptionHandler.setFaultVariable(variable);
        String code = Optional.ofNullable(hasErrorCode).filter(Boolean.TRUE::equals).map(v -> errorCode).orElse(null);
        exceptionScope.setExceptionHandler(code, exceptionHandler);
        if (errorStructureRef != null) {
            exceptionScope.setExceptionHandler(errorStructureRef, exceptionHandler);
        }
        DroolsConsequenceAction cancelAction = new DroolsConsequenceAction("java", null);
        cancelAction.setMetaData("Action", new CancelNodeInstanceAction(attachedTo));
        List actions = Optional.ofNullable(eventNode.getActions("onExit")).orElseGet(ArrayList::new);
        actions.add(cancelAction);
        eventNode.setActions("onExit", actions);
    }

    protected DroolsAction timerAction(String type) {
        DroolsAction signal = new DroolsAction();
        Action action = kcontext -> kcontext.getProcessInstance().signalEvent(type, (Object)kcontext.getNodeInstance().getStringId());
        signal.wire(action);
        return signal;
    }

    protected Node findNodeByIdOrUniqueIdInMetadata(NodeContainer nodeContainer, String nodeRef, String errorMsg) {
        Node node = null;
        for (Node containerNode : nodeContainer.getNodes()) {
            if (!nodeRef.equals(containerNode.getMetaData().get("UniqueId"))) continue;
            node = containerNode;
            break;
        }
        if (node == null) {
            throw new IllegalArgumentException(errorMsg);
        }
        return node;
    }

    private void postProcessNodes(RuleFlowProcess process, NodeContainer container) {
        for (Node node : container.getNodes()) {
            if (!(node instanceof NodeContainer)) continue;
            if (node instanceof EventSubProcessNode) {
                Node[] nodes;
                EventSubProcessNode eventSubProcessNode = (EventSubProcessNode)node;
                for (Node subNode : nodes = eventSubProcessNode.getNodes()) {
                    if (!(subNode instanceof StartNode)) continue;
                    this.processEventSubprocessStartNode((StartNode)subNode, eventSubProcessNode);
                }
            }
            this.postProcessNodes(process, (NodeContainer)node);
        }
    }

    private void processEventSubprocessStartNode(StartNode subNode, EventSubProcessNode eventSubProcessNode) {
        List<Trigger> triggers = subNode.getTriggers();
        if (triggers != null) {
            for (Trigger trigger : triggers) {
                if (!(trigger instanceof EventTrigger)) continue;
                List<EventFilter> filters = ((EventTrigger)trigger).getEventFilters();
                for (EventFilter filter : filters) {
                    eventSubProcessNode.addEvent((EventTypeFilter)filter);
                }
            }
        }
    }
}

