/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.coverter;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.coverter.DataTypeDeserializer;
import org.jbpm.process.core.datatype.impl.coverter.DataTypeSerializer;
import org.jbpm.process.core.datatype.impl.coverter.DateTypeConverter;
import org.jbpm.process.core.datatype.impl.coverter.JacksonConverter;
import org.jbpm.process.core.datatype.impl.coverter.JacksonUnconverter;
import org.jbpm.process.core.datatype.impl.coverter.NoOpTypeConverter;
import org.kie.kogito.jackson.utils.JsonNodeConverter;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.jackson.utils.StringConverter;

public class TypeConverterRegistry {
    private static TypeConverterRegistry INSTANCE = new TypeConverterRegistry();
    private Map<String, Function<String, ? extends Object>> converters = new HashMap<String, Function<String, ? extends Object>>();
    private Map<String, Function<? extends Object, String>> unconverters = new HashMap<String, Function<? extends Object, String>>();
    private Function<String, String> defaultConverter = new NoOpTypeConverter();

    private TypeConverterRegistry() {
        this.converters.put(Date.class.getName(), new DateTypeConverter());
        this.converters.put(JsonNode.class.getName(), (Function<String, ? extends Object>)new JsonNodeConverter(ObjectMapperFactory::listenerAware));
        this.unconverters.put(JsonNode.class.getName(), (Function<? extends Object, String>)new StringConverter());
        this.addJacksonPair(Variable.class, Map.class);
    }

    private void addJacksonPair(Class<?> ... classes) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(DataType.class, (JsonSerializer)new DataTypeSerializer()).addDeserializer(DataType.class, (JsonDeserializer)new DataTypeDeserializer());
        ObjectMapperFactory.get().registerModule((Module)module);
        for (Class<?> clazz : classes) {
            this.converters.put(clazz.getName(), new JacksonConverter(clazz));
            this.unconverters.put(clazz.getName(), new JacksonUnconverter());
        }
    }

    public boolean isRegistered(String type) {
        return this.converters.containsKey(type);
    }

    public Function<String, ? extends Object> forType(String type) {
        return this.converters.getOrDefault(type, this.defaultConverter);
    }

    public <T> Function<T, String> forTypeReverse(T obj) {
        Function<? extends Object, String> result = null;
        Class<?> clazz = obj.getClass();
        do {
            result = this.unconverters.get(clazz.getName());
        } while ((clazz = clazz.getSuperclass()) != null && result == null);
        return result == null ? Object::toString : result;
    }

    public TypeConverterRegistry register(String type, Function<String, ? extends Object> converter) {
        this.converters.put(type, converter);
        return this;
    }

    public <T> TypeConverterRegistry registerUnconverter(String type, Function<T, String> unconverter) {
        this.unconverters.put(type, unconverter);
        return this;
    }

    public static TypeConverterRegistry get() {
        return INSTANCE;
    }
}

