/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager.deploy;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.xml.sax.SAXException;

public class DeploymentDescriptorIO {
    private static JAXBContext context = null;
    private static Schema schema = null;

    public static DeploymentDescriptor fromXml(InputStream inputStream) {
        try {
            Unmarshaller unmarshaller = DeploymentDescriptorIO.getContext().createUnmarshaller();
            unmarshaller.setSchema(schema);
            DeploymentDescriptor descriptor = (DeploymentDescriptor)unmarshaller.unmarshal(inputStream);
            return descriptor;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read deployment descriptor from xml", e);
        }
    }

    public static String toXml(DeploymentDescriptor descriptor) {
        try {
            Marshaller marshaller = DeploymentDescriptorIO.getContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.schemaLocation", (Object)"http://www.jboss.org/jbpm deployment-descriptor.xsd");
            marshaller.setSchema(schema);
            StringWriter stringWriter = new StringWriter();
            DeploymentDescriptor clone = ((DeploymentDescriptorImpl)descriptor).clearClone();
            marshaller.marshal((Object)clone, (Writer)stringWriter);
            String output = stringWriter.toString();
            return output;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate xml from deployment descriptor", e);
        }
    }

    public static JAXBContext getContext() throws JAXBException, SAXException {
        if (context == null) {
            Class[] jaxbClasses = new Class[]{DeploymentDescriptorImpl.class};
            context = JAXBContext.newInstance((Class[])jaxbClasses);
            URL schemaLocation = DeploymentDescriptorIO.class.getResource("/deployment-descriptor.xsd");
            schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaLocation);
        }
        return context;
    }
}

