/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.feel.lang.ast.FunctionInvocationNode;
import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.kie.dmn.feel.lang.ast.InfixOperator;
import org.kie.dmn.feel.lang.ast.NumberNode;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.functions.BuiltInFunctions;
import org.kie.dmn.openapi.impl.FEELFunctionSchemaMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfixOpNodeSchemaMapper {
    private static final Logger LOG = LoggerFactory.getLogger(InfixOpNodeSchemaMapper.class);

    static void populateSchemaFromFunctionInvocationNode(Schema toPopulate, InfixOpNode infixOpNode) {
        LOG.debug("populateSchemaFromFunctionInvocationNode {} {}", (Object)toPopulate, (Object)infixOpNode);
        String functionString = ((FunctionInvocationNode)infixOpNode.getLeft()).getName().getText();
        FEELFunction function = BuiltInFunctions.getFunction((String)functionString);
        InfixOperator operator = infixOpNode.getOperator();
        Object rightValue = infixOpNode.getRight();
        if (rightValue instanceof NumberNode) {
            NumberNode numberNode = (NumberNode)rightValue;
            rightValue = numberNode.getValue();
        }
        FEELFunctionSchemaMapper.populateSchemaFromFEELFunction(function, operator, rightValue, toPopulate);
    }

    private InfixOpNodeSchemaMapper() {
    }
}

