/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import java.util.List;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.typesafe.DMNTypeUtils;

public class FEELBuiltinTypeSchemaMapper {
    public static Schema from(DMNType t) {
        BuiltInType builtin = DMNTypeUtils.getFEELBuiltInType((DMNType)t);
        if (builtin == BuiltInType.DURATION) {
            return FEELBuiltinTypeSchemaMapper.convertDurationToSchema(t);
        }
        return FEELBuiltinTypeSchemaMapper.convertBuiltInToJavaClass(builtin);
    }

    private static Schema convertDurationToSchema(DMNType t) {
        switch (t.getName()) {
            case "years and months duration": 
            case "yearMonthDuration": {
                return ((Schema)((Schema)OASFactory.createObject(Schema.class)).addExtension("x-dmn-type", (Object)"FEEL:years and months duration")).addType(Schema.SchemaType.STRING).format("years and months duration").examples(List.of("P1Y2M"));
            }
            case "days and time duration": 
            case "dayTimeDuration": {
                return ((Schema)((Schema)OASFactory.createObject(Schema.class)).addExtension("x-dmn-type", (Object)"FEEL:days and time duration")).addType(Schema.SchemaType.STRING).format("days and time duration").examples(List.of("P1D"));
            }
        }
        throw new IllegalArgumentException();
    }

    private static Schema convertBuiltInToJavaClass(BuiltInType builtin) {
        switch (builtin) {
            case UNKNOWN: {
                return (Schema)((Schema)OASFactory.createObject(Schema.class)).addExtension("x-dmn-type", (Object)"FEEL:Any");
            }
            case DATE: {
                return (Schema)((Schema)OASFactory.createObject(Schema.class)).addType(Schema.SchemaType.STRING).format("date").addExtension("x-dmn-type", (Object)"FEEL:date");
            }
            case TIME: {
                return (Schema)((Schema)OASFactory.createObject(Schema.class)).addType(Schema.SchemaType.STRING).format("time").addExtension("x-dmn-type", (Object)"FEEL:time");
            }
            case DATE_TIME: {
                return (Schema)((Schema)OASFactory.createObject(Schema.class)).addType(Schema.SchemaType.STRING).format("date-time").addExtension("x-dmn-type", (Object)"FEEL:date and time");
            }
            case BOOLEAN: {
                return (Schema)((Schema)OASFactory.createObject(Schema.class)).addType(Schema.SchemaType.BOOLEAN).addExtension("x-dmn-type", (Object)"FEEL:boolean");
            }
            case NUMBER: {
                return (Schema)((Schema)OASFactory.createObject(Schema.class)).addType(Schema.SchemaType.NUMBER).addExtension("x-dmn-type", (Object)"FEEL:number");
            }
            case STRING: {
                return (Schema)((Schema)OASFactory.createObject(Schema.class)).addType(Schema.SchemaType.STRING).addExtension("x-dmn-type", (Object)"FEEL:string");
            }
            case CONTEXT: {
                return (Schema)((Schema)OASFactory.createObject(Schema.class)).addExtension("x-dmn-type", (Object)"FEEL:context");
            }
        }
        throw new IllegalArgumentException("Unsupported built-in type: " + builtin);
    }

    private FEELBuiltinTypeSchemaMapper() {
    }
}

