/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.efesto.runtime.service;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.core.internal.utils.DynamicDMNContextBuilder;
import org.kie.internal.io.ResourceFactory;

public class DMNEvaluator {
    private final DMNModel dmnModel;
    private final DMNRuntime dmnRuntime;

    public static DMNEvaluator fromXML(String modelXML) {
        Resource modelResource = ResourceFactory.newReaderResource((Reader)new StringReader(modelXML), (String)"UTF-8");
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Collections.singletonList(modelResource)).getOrElseThrow(RuntimeException::new);
        DMNModel dmnModel = (DMNModel)dmnRuntime.getModels().get(0);
        return new DMNEvaluator(dmnModel, dmnRuntime);
    }

    public static DMNEvaluator fromDMNModel(DMNModel dmnModel) {
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Collections.emptyList()).getOrElseThrow(RuntimeException::new);
        return new DMNEvaluator(dmnModel, dmnRuntime);
    }

    private DMNEvaluator(DMNModel dmnModel, DMNRuntime dmnRuntime) {
        this.dmnModel = dmnModel;
        this.dmnRuntime = dmnRuntime;
    }

    public DMNModel getDmnModel() {
        return this.dmnModel;
    }

    public String getNamespace() {
        return this.dmnModel.getNamespace();
    }

    public String getName() {
        return this.dmnModel.getName();
    }

    public Collection<DMNModel> getAllDMNModels() {
        return this.dmnRuntime.getModels();
    }

    public DMNResult evaluate(Map<String, Object> context) {
        DMNContext dmnContext = new DynamicDMNContextBuilder(this.dmnRuntime.newContext(), this.dmnModel).populateContextWith(context);
        return this.dmnRuntime.evaluateAll(this.dmnModel, dmnContext);
    }
}

