/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.efesto.compiler.utils;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.kie.api.builder.Message;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.efesto.compiler.model.EfestoCallableOutputDMN;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.internal.io.ResourceFactory;

public class DmnCompilerUtils {
    static final List<String> CLEANABLE_PATTERNS = Arrays.asList("main/resources", "main/java", "test/resources", "test/java", "target/generated-resources", "target/classes", "target/test-classes");

    private DmnCompilerUtils() {
    }

    public static boolean hasError(List<DMNMessage> dmnMessages) {
        return dmnMessages.stream().anyMatch(dmnMessage -> dmnMessage.getLevel().equals((Object)Message.Level.ERROR));
    }

    public static EfestoCompilationOutput getDefaultEfestoCompilationOutput(String fileName, String modelName, String modelSource, DMNModel dmnModel, List<DMNMessage> validationMessages) {
        return new EfestoCallableOutputDMN(fileName, modelName, modelSource, dmnModel, validationMessages);
    }

    public static EfestoCompilationOutput getDefaultEfestoCompilationOutput(ModelLocalUriId modelLocalUriId, String modelSource, DMNModel dmnModel, List<DMNMessage> validationMessages) {
        return new EfestoCallableOutputDMN(modelLocalUriId, modelSource, dmnModel, validationMessages);
    }

    public static DMNModel getDMNModel(String modelSource, String fileName) {
        Resource modelResource = ResourceFactory.newReaderResource((Reader)new StringReader(modelSource), (String)"UTF-8");
        modelResource.setSourcePath(fileName);
        return DmnCompilerUtils.getDMNModel(modelResource);
    }

    public static DMNModel getDMNModel(Resource modelResource) {
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Collections.singletonList(modelResource)).getOrElseThrow(RuntimeException::new);
        return (DMNModel)dmnRuntime.getModels().get(0);
    }

    public static List<DMNModel> getDMNModelsFromFiles(Set<File> modelFiles, Set<DMNProfile> customDMNProfiles, RuntimeTypeCheckOption runtimeTypeCheckOption, ClassLoader classLoader) {
        List<Resource> modelResources = modelFiles.stream().map(ResourceFactory::newFileResource).toList();
        DMNRuntimeBuilder dmnRuntimeBuilder = DMNRuntimeBuilder.fromDefaults();
        if (runtimeTypeCheckOption != null) {
            dmnRuntimeBuilder.setOption(runtimeTypeCheckOption);
        }
        if (customDMNProfiles != null) {
            customDMNProfiles.forEach(arg_0 -> ((DMNRuntimeBuilder)dmnRuntimeBuilder).addProfile(arg_0));
        }
        DMNRuntime dmnRuntime = (DMNRuntime)dmnRuntimeBuilder.setRootClassLoader(classLoader).buildConfiguration().fromResources(modelResources).getOrElseThrow(RuntimeException::new);
        return dmnRuntime.getModels();
    }

    public static List<DMNModel> getDMNModelsFromResources(Collection<Resource> dmnResources, Set<DMNProfile> customDMNProfiles, RuntimeTypeCheckOption runtimeTypeCheckOption, ClassLoader classLoader) {
        DMNRuntimeBuilder dmnRuntimeBuilder = DMNRuntimeBuilder.fromDefaults();
        if (runtimeTypeCheckOption != null) {
            dmnRuntimeBuilder.setOption(runtimeTypeCheckOption);
        }
        if (customDMNProfiles != null) {
            customDMNProfiles.forEach(arg_0 -> ((DMNRuntimeBuilder)dmnRuntimeBuilder).addProfile(arg_0));
        }
        DMNRuntime dmnRuntime = (DMNRuntime)dmnRuntimeBuilder.setRootClassLoader(classLoader).buildConfiguration().fromResources(dmnResources).getOrElseThrow(RuntimeException::new);
        return dmnRuntime.getModels();
    }

    public static String getCleanedFilenameForURI(File fileToClean) {
        return DmnCompilerUtils.getCleanedFilenameForURI(fileToClean.getPath());
    }

    public static String getCleanedFilenameForURI(String filenameToClean) {
        if (filenameToClean == null) {
            return filenameToClean;
        }
        String toReturn = filenameToClean;
        for (String patternToClean : CLEANABLE_PATTERNS) {
            toReturn = DmnCompilerUtils.getCleanedFileNameForURIByPattern(toReturn, patternToClean);
        }
        if (toReturn != null && toReturn.startsWith("/")) {
            toReturn = toReturn.substring(1);
        }
        return toReturn;
    }

    static String getCleanedFileNameForURIByPattern(String filenameToClean, String patternToClean) {
        if (filenameToClean == null) {
            return filenameToClean;
        }
        String toReturn = filenameToClean.replace(File.separator, "/");
        if (toReturn.endsWith(".dmn")) {
            toReturn = toReturn.substring(0, toReturn.lastIndexOf(".dmn"));
        }
        if (toReturn.contains(patternToClean)) {
            toReturn = toReturn.substring(toReturn.indexOf(patternToClean) + patternToClean.length());
        }
        return toReturn;
    }
}

