/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.efesto.compiler.service;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.kie.dmn.efesto.compiler.model.DmnCompilationContext;
import org.kie.dmn.efesto.compiler.service.AbstractKieCompilerServiceDMN;
import org.kie.dmn.efesto.compiler.utils.DmnCompilerUtils;
import org.kie.efesto.common.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoInputStreamResource;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieCompilerServiceDMNInputStream
extends AbstractKieCompilerServiceDMN {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieCompilerServiceDMNInputStream.class);

    public boolean canManageResource(EfestoResource toProcess) {
        EfestoInputStreamResource efestoInputStreamResource;
        return toProcess instanceof EfestoInputStreamResource && (efestoInputStreamResource = (EfestoInputStreamResource)toProcess).getModelType().equalsIgnoreCase("dmn");
    }

    public List<EfestoCompilationOutput> processResource(EfestoResource toProcess, EfestoCompilationContext context) {
        String modelSource;
        if (!this.canManageResource(toProcess)) {
            throw new KieCompilerServiceException(String.format("%s can not process %s", this.getClass().getName(), toProcess.getClass().getName()));
        }
        if (!(context instanceof DmnCompilationContext)) {
            throw new KieCompilerServiceException(String.format("Wrong %s context parameter for from %s", context.getClass().getName(), this.getClass().getName()));
        }
        DmnCompilationContext dmnContext = (DmnCompilationContext)context;
        EfestoInputStreamResource inputStreamResource = (EfestoInputStreamResource)toProcess;
        try {
            modelSource = new String(inputStreamResource.getContent().readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new KieCompilerServiceException(String.format("Unable to read content from %s", toProcess), (Throwable)e);
        }
        String fileName = DmnCompilerUtils.getCleanedFilenameForURI(inputStreamResource.getFileName());
        List<AbstractKieCompilerServiceDMN.ModelSourceTuple> modelSourceTuples = Collections.singletonList(new AbstractKieCompilerServiceDMN.ModelSourceTuple(DmnCompilerUtils.getDMNModel(modelSource, fileName), modelSource));
        return this.getListEfestoCompilationOutput(modelSourceTuples, dmnContext, LOGGER);
    }
}

