/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.efesto.compiler.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.io.ByteArrayResource;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.identifiers.DmnIdFactory;
import org.kie.dmn.api.identifiers.KieDmnComponentRoot;
import org.kie.dmn.api.identifiers.LocalCompilationSourceIdDmn;
import org.kie.dmn.core.compiler.profiles.ExtendedDMNProfile;
import org.kie.dmn.efesto.compiler.model.DmnCompilationContext;
import org.kie.dmn.efesto.compiler.utils.DmnCompilerUtils;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.DMNValidatorFactory;
import org.kie.efesto.common.api.identifiers.EfestoAppRoot;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.model.EfestoCompilationContext;
import org.kie.efesto.common.core.storage.ContextStorage;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;
import org.kie.efesto.compilationmanager.core.model.EfestoCompilationContextImpl;
import org.slf4j.Logger;

public abstract class AbstractKieCompilerServiceDMN
implements KieCompilerService<EfestoCompilationOutput, EfestoCompilationContext> {
    public boolean hasCompilationSource(String fileName) {
        LocalCompilationSourceIdDmn localCompilationSourceIdDmn = ((DmnIdFactory)((KieDmnComponentRoot)new EfestoAppRoot().get(KieDmnComponentRoot.class)).get(DmnIdFactory.class)).get(fileName);
        return ContextStorage.getEfestoCompilationSource((ModelLocalUriId)localCompilationSourceIdDmn) != null;
    }

    public String getCompilationSource(String fileName) {
        LocalCompilationSourceIdDmn localCompilationSourceIdDmn = ((DmnIdFactory)((KieDmnComponentRoot)new EfestoAppRoot().get(KieDmnComponentRoot.class)).get(DmnIdFactory.class)).get(fileName);
        return ContextStorage.getEfestoCompilationSource((ModelLocalUriId)localCompilationSourceIdDmn);
    }

    public String getModelType() {
        return "dmn";
    }

    protected DmnCompilationContext getDmnCompilationContext(EfestoCompilationContext context) {
        DmnCompilationContext dmnCompilationContext;
        return context instanceof DmnCompilationContext ? (dmnCompilationContext = (DmnCompilationContext)context) : DmnCompilationContext.buildWithEfestoCompilationContext((EfestoCompilationContextImpl)context);
    }

    protected List<DMNMessage> validateDMN(EfestoCompilationContext context, Collection<Resource> resources) {
        DmnCompilationContext dmnCompilationContext = this.getDmnCompilationContext(context);
        if (dmnCompilationContext.getValidations() == null || dmnCompilationContext.getValidations().isEmpty()) {
            return Collections.emptyList();
        }
        return DMNValidatorFactory.newValidator(List.of(new ExtendedDMNProfile())).validateUsing(dmnCompilationContext.getValidations().toArray(new DMNValidator.Validation[0])).theseModels(resources.toArray(new Resource[0]));
    }

    protected List<EfestoCompilationOutput> getListEfestoCompilationOutput(List<ModelSourceTuple> modelSourceTuples, DmnCompilationContext dmnContext, Logger logger) {
        try {
            HashMap<LocalCompilationSourceIdDmn, ModelSourceTuple> mappedModelSourceTuple = new HashMap<LocalCompilationSourceIdDmn, ModelSourceTuple>();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (ModelSourceTuple modelSourceTuple2 : modelSourceTuples) {
                LocalCompilationSourceIdDmn key = this.getLocalCompilationSourceIdDmnFromModelSourceTuple(modelSourceTuple2);
                if (mappedModelSourceTuple.containsKey(key)) {
                    logger.warn("Duplicate LocalCompilationSourceIdDmn key {} for model {}  ", (Object)key, (Object)modelSourceTuple2.model);
                    continue;
                }
                mappedModelSourceTuple.put(key, modelSourceTuple2);
                resources.add((Resource)new ByteArrayResource(modelSourceTuple2.source.getBytes(StandardCharsets.UTF_8)));
            }
            ArrayList<EfestoCompilationOutput> toReturn = new ArrayList<EfestoCompilationOutput>();
            List<DMNMessage> validationMessages = this.validateDMN(dmnContext, resources);
            mappedModelSourceTuple.values().forEach(modelSourceTuple -> {
                DMNModel dmnModel = modelSourceTuple.model;
                String modelSource = modelSourceTuple.source;
                File dmnFile = new File(dmnModel.getResource().getSourcePath());
                toReturn.add(DmnCompilerUtils.getDefaultEfestoCompilationOutput(DmnCompilerUtils.getCleanedFilenameForURI(dmnFile), dmnModel.getName(), modelSource, dmnModel, validationMessages));
            });
            this.storeMappedModelTuple(mappedModelSourceTuple);
            return toReturn;
        }
        catch (Exception e) {
            throw new KieCompilerServiceException((Throwable)e);
        }
    }

    protected void storeMappedModelTuple(Map<LocalCompilationSourceIdDmn, ModelSourceTuple> mappedModelTuple) {
        mappedModelTuple.forEach((localCompilationSourceIdDmn, modelSourceTuple) -> ContextStorage.putEfestoCompilationSource((ModelLocalUriId)localCompilationSourceIdDmn, (String)modelSourceTuple.source));
    }

    protected LocalCompilationSourceIdDmn getLocalCompilationSourceIdDmnFromModelSourceTuple(ModelSourceTuple modelSourceTuple) {
        String fileName = modelSourceTuple.model.getResource().getSourcePath();
        fileName = DmnCompilerUtils.getCleanedFilenameForURI(fileName);
        return ((DmnIdFactory)((KieDmnComponentRoot)new EfestoAppRoot().get(KieDmnComponentRoot.class)).get(DmnIdFactory.class)).get(fileName);
    }

    protected ModelSourceTuple readDMNModel(DMNModel toRead) {
        return new ModelSourceTuple(toRead, this.readResource(toRead.getResource()));
    }

    private String readResource(Resource toRead) {
        String string;
        block8: {
            InputStream is = toRead.getInputStream();
            try {
                string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new KieCompilerServiceException((Throwable)e);
                }
            }
            is.close();
        }
        return string;
    }

    protected static class ModelSourceTuple {
        protected final DMNModel model;
        protected final String source;

        public ModelSourceTuple(DMNModel model, String source) {
            this.model = model;
            this.source = source;
        }
    }
}

