/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.efesto.compiler.model;

import java.util.Collections;
import java.util.Set;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.efesto.compiler.model.DmnCompilationContext;
import org.kie.dmn.validation.DMNValidator;
import org.kie.efesto.compilationmanager.core.model.EfestoCompilationContextImpl;
import org.kie.efesto.compilationmanager.core.model.EfestoCompilationContextUtils;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.memorycompiler.KieMemoryCompiler;

public class DmnCompilationContextImpl
extends EfestoCompilationContextImpl
implements DmnCompilationContext {
    private Set<DMNProfile> customDMNProfiles;
    private Set<DMNValidator.Validation> validations;
    private RuntimeTypeCheckOption runtimeTypeCheckOption;

    public static Builder builder(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        return new Builder(memoryCompilerClassLoader);
    }

    public static Builder builder(EfestoCompilationContextImpl context) {
        return new Builder(context);
    }

    public DmnCompilationContextImpl(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        this(memoryCompilerClassLoader, null, null, null);
    }

    private DmnCompilationContextImpl(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader, Set<DMNProfile> customDMNProfiles, Set<DMNValidator.Validation> validations, RuntimeTypeCheckOption runtimeTypeCheckOption) {
        super(memoryCompilerClassLoader, false);
        this.customDMNProfiles = customDMNProfiles;
        this.validations = validations;
        this.runtimeTypeCheckOption = runtimeTypeCheckOption;
    }

    @Override
    public KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration() {
        return KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((ClassLoader)this.memoryCompilerClassLoader);
    }

    @Override
    public Set<DMNProfile> getCustomDMNProfiles() {
        return this.customDMNProfiles;
    }

    @Override
    public Set<DMNValidator.Validation> getValidations() {
        return this.validations != null ? Collections.unmodifiableSet(this.validations) : Collections.emptySet();
    }

    @Override
    public RuntimeTypeCheckOption getRuntimeTypeCheckOption() {
        return this.runtimeTypeCheckOption;
    }

    @Override
    public ClassLoader getContextClassloader() {
        return this.memoryCompilerClassLoader;
    }

    public static class Builder {
        private final DmnCompilationContextImpl compilationContext;

        private Builder(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
            this.compilationContext = new DmnCompilationContextImpl(memoryCompilerClassLoader);
        }

        private Builder(EfestoCompilationContextImpl context) {
            this.compilationContext = (DmnCompilationContextImpl)EfestoCompilationContextUtils.buildFromContext((EfestoCompilationContextImpl)context, DmnCompilationContextImpl.class);
        }

        public Builder withCustomDMNProfiles(Set<DMNProfile> customDMNProfiles) {
            this.compilationContext.customDMNProfiles = customDMNProfiles;
            return this;
        }

        public Builder withValidations(Set<DMNValidator.Validation> validations) {
            this.compilationContext.validations = validations;
            return this;
        }

        public Builder withRuntimeTypeCheckOption(RuntimeTypeCheckOption runtimeTypeCheckOption) {
            this.compilationContext.runtimeTypeCheckOption = runtimeTypeCheckOption;
            return this;
        }

        public DmnCompilationContextImpl build() {
            return this.compilationContext;
        }
    }
}

