/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.efesto.compiler.model;

import java.util.Set;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.efesto.compiler.model.DmnCompilationContextImpl;
import org.kie.dmn.validation.DMNValidator;
import org.kie.efesto.common.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.core.model.EfestoCompilationContextImpl;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.memorycompiler.KieMemoryCompiler;

public interface DmnCompilationContext
extends EfestoCompilationContext {
    public static DmnCompilationContext buildWithParentClassLoader(ClassLoader parentClassLoader) {
        return DmnCompilationContextImpl.builder(new KieMemoryCompiler.MemoryCompilerClassLoader(parentClassLoader)).build();
    }

    public static DmnCompilationContext buildWithMemoryCompilerClassLoader(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        return DmnCompilationContextImpl.builder(memoryCompilerClassLoader).build();
    }

    public static DmnCompilationContext buildWithEfestoCompilationContext(EfestoCompilationContextImpl context) {
        return DmnCompilationContextImpl.builder(context).build();
    }

    public static DmnCompilationContext buildWithEfestoCompilationContext(EfestoCompilationContextImpl context, Set<DMNProfile> customDMNProfiles, Set<DMNValidator.Validation> validations, RuntimeTypeCheckOption runtimeTypeCheckOption) {
        return DmnCompilationContextImpl.builder(context).withCustomDMNProfiles(customDMNProfiles).withValidations(validations).withRuntimeTypeCheckOption(runtimeTypeCheckOption).build();
    }

    public static DmnCompilationContext buildWithParentClassLoader(ClassLoader parentClassLoader, Set<DMNProfile> customDMNProfiles, Set<DMNValidator.Validation> validations, RuntimeTypeCheckOption runtimeTypeCheckOption) {
        return DmnCompilationContextImpl.builder(new KieMemoryCompiler.MemoryCompilerClassLoader(parentClassLoader)).withCustomDMNProfiles(customDMNProfiles).withValidations(validations).withRuntimeTypeCheckOption(runtimeTypeCheckOption).build();
    }

    public KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration();

    public Set<DMNProfile> getCustomDMNProfiles();

    public Set<DMNValidator.Validation> getValidations();

    public RuntimeTypeCheckOption getRuntimeTypeCheckOption();

    public ClassLoader getContextClassloader();
}

