/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_5.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.kie.dmn.backend.marshalling.v1_5.xstream.ExpressionConverter;
import org.kie.dmn.model.api.ChildExpression;
import org.kie.dmn.model.api.Conditional;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_5.TChildExpression;
import org.kie.dmn.model.v1_5.TConditional;

public class ConditionalConverter
extends ExpressionConverter {
    public static final String IF = "if";
    public static final String THEN = "then";
    public static final String ELSE = "else";

    public ConditionalConverter(XStream xstream) {
        super(xstream);
    }

    @Override
    protected void assignChildElement(Object parent, String nodeName, Object child) {
        Conditional cond = (Conditional)parent;
        if (IF.equals(nodeName)) {
            cond.setIf((ChildExpression)child);
        } else if (THEN.equals(nodeName)) {
            cond.setThen((ChildExpression)child);
        } else if (ELSE.equals(nodeName)) {
            cond.setElse((ChildExpression)child);
        } else {
            super.assignChildElement(parent, nodeName, child);
        }
    }

    @Override
    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
        super.writeChildren(writer, context, parent);
        Conditional cond = (Conditional)parent;
        this.writeChildrenNode(writer, context, cond.getIf(), IF);
        this.writeChildrenNode(writer, context, cond.getThen(), THEN);
        this.writeChildrenNode(writer, context, cond.getElse(), ELSE);
    }

    @Override
    protected DMNModelInstrumentedBase createModelObject() {
        return new TConditional();
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(TConditional.class);
    }

    @Override
    protected void parseElements(HierarchicalStreamReader reader, UnmarshallingContext context, Object parent) {
        this.mvDownConvertAnotherMvUpAssignChildElement(reader, context, parent, IF, TChildExpression.class);
        this.mvDownConvertAnotherMvUpAssignChildElement(reader, context, parent, THEN, TChildExpression.class);
        this.mvDownConvertAnotherMvUpAssignChildElement(reader, context, parent, ELSE, TChildExpression.class);
    }
}

