/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_2.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.impl.AbstractKieDMNModelInstrumentedBase;

public abstract class DMNBaseConverter
extends AbstractCollectionConverter {
    public DMNBaseConverter(Mapper mapper) {
        super(mapper);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        this.writeAttributes(writer, object);
        this.writeChildren(writer, context, object);
    }

    protected void writeChildrenNode(HierarchicalStreamWriter writer, MarshallingContext context, Object node, String nodeAlias) {
        writer.startNode(nodeAlias);
        context.convertAnother(node);
        writer.endNode();
    }

    protected void writeChildrenNodeAsValue(HierarchicalStreamWriter writer, MarshallingContext context, String nodeValue, String nodeAlias) {
        writer.startNode(nodeAlias);
        writer.setValue(nodeValue);
        writer.endNode();
    }

    protected abstract void writeChildren(HierarchicalStreamWriter var1, MarshallingContext var2, Object var3);

    protected abstract void writeAttributes(HierarchicalStreamWriter var1, Object var2);

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        DMNModelInstrumentedBase obj = this.createModelObject();
        this.assignAttributes(reader, obj);
        this.parseElements(reader, context, obj);
        return obj;
    }

    protected void parseElements(HierarchicalStreamReader reader, UnmarshallingContext context, Object parent) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            Object object = this.readItem(reader, context, null);
            if (object instanceof DMNModelInstrumentedBase) {
                ((AbstractKieDMNModelInstrumentedBase)object).setParent((DMNModelInstrumentedBase)((AbstractKieDMNModelInstrumentedBase)parent));
                ((AbstractKieDMNModelInstrumentedBase)parent).addChildren((DMNModelInstrumentedBase)((AbstractKieDMNModelInstrumentedBase)object));
            }
            reader.moveUp();
            this.assignChildElement(parent, nodeName, object);
        }
    }

    protected abstract DMNModelInstrumentedBase createModelObject();

    protected abstract void assignChildElement(Object var1, String var2, Object var3);

    protected abstract void assignAttributes(HierarchicalStreamReader var1, Object var2);
}

