/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.kie.dmn.api.marshalling.DMNExtensionRegister;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.CustomStaxWriter;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.impl.AbstractKieDMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXStreamMarshaller
implements DMNMarshaller {
    private static Logger logger = LoggerFactory.getLogger(AbstractXStreamMarshaller.class);
    protected List<DMNExtensionRegister> extensionRegisters = new ArrayList<DMNExtensionRegister>();
    private final StaxDriver staxDriver;

    protected AbstractXStreamMarshaller(StaxDriver staxDriver) {
        this.staxDriver = staxDriver;
    }

    protected AbstractXStreamMarshaller(StaxDriver staxDriver, List<DMNExtensionRegister> extensionRegisters) {
        this(staxDriver);
        this.extensionRegisters.addAll(extensionRegisters);
    }

    public Definitions unmarshal(String xml) {
        return this.unmarshal(new StringReader(xml));
    }

    public Definitions unmarshal(Reader isr) {
        try {
            XStream xStream = this.getXStream();
            Definitions def = (Definitions)xStream.fromXML(isr);
            return def;
        }
        catch (Exception e) {
            logger.error("Error unmarshalling DMN model from reader.", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String marshal(Object o) {
        try (StringWriter writer = new StringWriter();){
            String string;
            block14: {
                CustomStaxWriter hsWriter = (CustomStaxWriter)this.staxDriver.createWriter((Writer)writer);
                try {
                    XStream xStream = this.getXStream();
                    if (o instanceof DMNModelInstrumentedBase) {
                        AbstractKieDMNModelInstrumentedBase base = (AbstractKieDMNModelInstrumentedBase)o;
                        String dmnPrefix = base.getNsContext().entrySet().stream().filter(kv -> this.isURIDMNEquals((String)kv.getValue())).findFirst().map(Map.Entry::getKey).orElse("");
                        hsWriter.getQNameMap().setDefaultPrefix(dmnPrefix);
                    }
                    this.extensionRegisters.forEach(r -> r.beforeMarshal(o, hsWriter.getQNameMap()));
                    xStream.marshal(o, (HierarchicalStreamWriter)hsWriter);
                    hsWriter.flush();
                    string = ((Object)writer).toString();
                    if (hsWriter == null) break block14;
                }
                catch (Throwable throwable) {
                    if (hsWriter != null) {
                        try {
                            hsWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                hsWriter.close();
            }
            return string;
        }
        catch (Exception e) {
            logger.error("Error marshalling DMN model to XML.", (Throwable)e);
            return null;
        }
    }

    public void marshal(Object o, Writer out) {
        try {
            out.write(this.marshal(o));
        }
        catch (Exception e) {
            logger.error("Error marshalling DMN model to XML.", (Throwable)e);
        }
    }

    protected abstract boolean isURIDMNEquals(String var1);

    protected abstract XStream newXStream();

    private XStream getXStream() {
        XStream toReturn = this.newXStream();
        HashSet<String> allowedTypes = new HashSet<String>();
        this.extensionRegisters.forEach(r -> allowedTypes.addAll(r.allowedModelPackages()));
        allowedTypes.add("org.kie.dmn.model.**");
        toReturn.allowTypesByWildcard(allowedTypes.toArray(new String[0]));
        return toReturn;
    }
}

