/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.api.core;

import java.util.Collection;

public enum DMNVersion {
    V1_1(11, "v1_1"),
    V1_2(12, "v1_2"),
    V1_3(13, "v1_3"),
    V1_4(14, "v1_4"),
    V1_5(15, "v1_5"),
    V1_6(16, "v1_6");

    private final int dmnVersion;
    private final String dmnVersionString;

    private DMNVersion(int dmnVersion, String dmnVersionString) {
        this.dmnVersion = dmnVersion;
        this.dmnVersionString = dmnVersionString;
    }

    public int getDmnVersion() {
        return this.dmnVersion;
    }

    public static DMNVersion getLatest() {
        DMNVersion latest = null;
        for (DMNVersion version : DMNVersion.values()) {
            if (latest != null && version.dmnVersion <= latest.dmnVersion) continue;
            latest = version;
        }
        return latest;
    }

    public static String getLatestDmnVersionString() {
        return DMNVersion.getLatest().dmnVersionString;
    }

    public static DMNVersion inferDMNVersion(Collection<String> nsContextValues) {
        DMNVersion toReturn = DMNVersion.getLatest();
        if (nsContextValues.stream().anyMatch("https://www.omg.org/spec/DMN/20240513/MODEL/"::equals)) {
            toReturn = V1_6;
        } else if (nsContextValues.stream().anyMatch("https://www.omg.org/spec/DMN/20230324/MODEL/"::equals)) {
            toReturn = V1_5;
        } else if (nsContextValues.stream().anyMatch("https://www.omg.org/spec/DMN/20211108/MODEL/"::equals)) {
            toReturn = V1_4;
        } else if (nsContextValues.stream().anyMatch("https://www.omg.org/spec/DMN/20191111/MODEL/"::equals)) {
            toReturn = V1_3;
        } else if (nsContextValues.stream().anyMatch("http://www.omg.org/spec/DMN/20180521/MODEL/"::equals)) {
            toReturn = V1_2;
        } else if (nsContextValues.stream().anyMatch("http://www.omg.org/spec/DMN/20151101/dmn.xsd"::equals)) {
            toReturn = V1_1;
        }
        return toReturn;
    }
}

