/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.compilationmanager.core.model;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.listener.EfestoListener;
import org.kie.efesto.common.api.model.EfestoCompilationContext;
import org.kie.efesto.common.api.model.GeneratedModelResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.core.utils.JSONUtils;
import org.kie.efesto.compilationmanager.api.exceptions.EfestoCompilationManagerException;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.model.EfestoStringResource;
import org.kie.efesto.compilationmanager.api.service.CompilationManager;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;
import org.kie.efesto.compilationmanager.api.utils.SPIUtils;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.memorycompiler.KieMemoryCompilerException;

public class EfestoCompilationContextImpl<T extends EfestoListener>
implements EfestoCompilationContext<T> {
    private static final CompilationManager compilationManager = (CompilationManager)SPIUtils.getCompilationManager((boolean)true).orElseThrow(() -> new RuntimeException("Compilation Manager not available"));
    protected final KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader;
    protected final Map<String, GeneratedResources> generatedResourcesMap = new HashMap<String, GeneratedResources>();

    protected EfestoCompilationContextImpl(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        this.memoryCompilerClassLoader = memoryCompilerClassLoader;
        this.prepareClassLoader();
        this.populateGeneratedResourcesMap();
    }

    protected EfestoCompilationContextImpl(KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader, boolean setup) {
        this.memoryCompilerClassLoader = memoryCompilerClassLoader;
        if (setup) {
            this.prepareClassLoader();
            this.populateGeneratedResourcesMap();
        }
    }

    private void prepareClassLoader() {
        for (ModelLocalUriId modelLocalUriId : this.localUriIdKeySet()) {
            Map generatedClasses = this.getGeneratedClasses(modelLocalUriId);
            generatedClasses.forEach((arg_0, arg_1) -> ((KieMemoryCompiler.MemoryCompilerClassLoader)this.memoryCompilerClassLoader).addCodeIfAbsent(arg_0, arg_1));
        }
    }

    private void populateGeneratedResourcesMap() {
        Set modelTypes = SPIUtils.collectModelTypes((EfestoCompilationContext)this);
        Map indexFileMap = IndexFile.findIndexFilesFromClassLoader((ClassLoader)this.memoryCompilerClassLoader, (Set)modelTypes);
        indexFileMap.forEach((model, indexFile) -> {
            try {
                GeneratedResources generatedResources = this.getInstantiatedResources((IndexFile)indexFile);
                this.generatedResourcesMap.put((String)model, generatedResources);
            }
            catch (Exception e) {
                throw new EfestoCompilationManagerException("Failed to read IndexFile content : " + indexFile.getAbsolutePath(), (Throwable)e);
            }
        });
    }

    public Map<String, GeneratedResources> getGeneratedResourcesMap() {
        return this.generatedResourcesMap;
    }

    public void addGeneratedResources(String model, GeneratedResources generatedResources) {
        this.generatedResourcesMap.put(model, generatedResources);
    }

    public Map<String, byte[]> compileClasses(Map<String, String> sourcesMap) {
        return KieMemoryCompiler.compileNoLoad(sourcesMap, (ClassLoader)this.memoryCompilerClassLoader, (JavaConfiguration.CompilerType)JavaConfiguration.CompilerType.NATIVE);
    }

    public void loadClasses(Map<String, byte[]> compiledClassesMap) {
        for (Map.Entry<String, byte[]> entry : compiledClassesMap.entrySet()) {
            this.memoryCompilerClassLoader.addCode(entry.getKey(), entry.getValue());
            try {
                this.memoryCompilerClassLoader.loadClass(entry.getKey());
            }
            catch (ClassNotFoundException e) {
                throw new KieMemoryCompilerException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public ServiceLoader<KieCompilerService> getKieCompilerServiceLoader() {
        return ServiceLoader.load(KieCompilerService.class, (ClassLoader)this.memoryCompilerClassLoader);
    }

    public byte[] getCode(String name) {
        return this.memoryCompilerClassLoader.getCode(name);
    }

    public Map<String, IndexFile> createIndexFiles(Path targetDirectory) {
        HashMap<String, IndexFile> indexFiles = new HashMap<String, IndexFile>();
        for (Map.Entry<String, GeneratedResources> entry : this.generatedResourcesMap.entrySet()) {
            String model = entry.getKey();
            GeneratedResources generatedResources = entry.getValue();
            IndexFile indexFile = new IndexFile(targetDirectory.toString(), model);
            try {
                if (indexFile.exists()) {
                    GeneratedResources existingGeneratedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
                    generatedResources.addAll((Collection)existingGeneratedResources);
                }
                JSONUtils.writeGeneratedResourcesObject((GeneratedResources)generatedResources, (IndexFile)indexFile);
            }
            catch (Exception e) {
                throw new EfestoCompilationManagerException("Failed to write to IndexFile : " + indexFile.getAbsolutePath(), (Throwable)e);
            }
            indexFiles.put(model, indexFile);
        }
        return indexFiles;
    }

    private GeneratedResources getInstantiatedResources(IndexFile indexFile) throws IOException {
        GeneratedResources readResources = JSONUtils.getGeneratedResourcesObject((IndexFile)indexFile);
        GeneratedResources toReturn = new GeneratedResources();
        readResources.forEach(resource -> {
            GeneratedModelResource generatedModelResource;
            if (resource instanceof GeneratedModelResource && (generatedModelResource = (GeneratedModelResource)resource).getCompiledModel() == null) {
                GeneratedModelResource toAdd = this.compileGeneratedModelResource(generatedModelResource);
                toReturn.add((Object)toAdd);
            } else {
                toReturn.add(resource);
            }
        });
        return toReturn;
    }

    private GeneratedModelResource compileGeneratedModelResource(GeneratedModelResource toCompile) {
        EfestoStringResource resource = new EfestoStringResource(toCompile.getModelSource(), toCompile.getModelLocalUriId());
        compilationManager.processResource((EfestoCompilationContext)this, new EfestoResource[]{resource});
        Map<String, GeneratedResources> generatedResourcesMap = this.getGeneratedResourcesMap();
        Map.Entry generatedResourcesEntry = generatedResourcesMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("dmn")).findFirst().orElseThrow(() -> new EfestoCompilationManagerException());
        return ((GeneratedResources)generatedResourcesEntry.getValue()).stream().filter(GeneratedModelResource.class::isInstance).map(GeneratedModelResource.class::cast).findFirst().orElseThrow(() -> new EfestoCompilationManagerException());
    }
}

