/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.core.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.model.EfestoCompilationContext;
import org.kie.efesto.common.api.model.EfestoRuntimeContext;

public class ContextStorage {
    private static final Map<ModelLocalUriId, EfestoCompilationContext> COMPILATION_CONTEXT_MAP = new HashMap<ModelLocalUriId, EfestoCompilationContext>();
    private static final Map<ModelLocalUriId, String> COMPILATION_SOURCE_MAP = new HashMap<ModelLocalUriId, String>();
    private static final Map<ModelLocalUriId, EfestoRuntimeContext> RUNTIME_CONTEXT_MAP = new HashMap<ModelLocalUriId, EfestoRuntimeContext>();

    public static void reset() {
        COMPILATION_CONTEXT_MAP.clear();
        COMPILATION_SOURCE_MAP.clear();
        RUNTIME_CONTEXT_MAP.clear();
    }

    public static void putEfestoCompilationContext(ModelLocalUriId modelLocalUriId, EfestoCompilationContext compilationContext) {
        COMPILATION_CONTEXT_MAP.put(modelLocalUriId, compilationContext);
    }

    public static EfestoCompilationContext getEfestoCompilationContext(ModelLocalUriId modelLocalUriId) {
        return COMPILATION_CONTEXT_MAP.get(modelLocalUriId);
    }

    public static void putEfestoCompilationSource(ModelLocalUriId modelLocalUriId, String content) {
        COMPILATION_SOURCE_MAP.put(modelLocalUriId, content);
    }

    public static String getEfestoCompilationSource(ModelLocalUriId modelLocalUriId) {
        return COMPILATION_SOURCE_MAP.get(modelLocalUriId);
    }

    public static Collection<ModelLocalUriId> getAllModelLocalUriIdFromCompilationContext() {
        return COMPILATION_CONTEXT_MAP.keySet();
    }

    public static void putEfestoRuntimeContext(ModelLocalUriId modelLocalUriId, EfestoRuntimeContext runtimeContext) {
        RUNTIME_CONTEXT_MAP.put(modelLocalUriId, runtimeContext);
    }

    public static EfestoRuntimeContext getEfestoRuntimeContext(ModelLocalUriId modelLocalUriId) {
        return RUNTIME_CONTEXT_MAP.get(modelLocalUriId);
    }
}

