/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import org.kie.efesto.common.api.cache.EfestoClassKey;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;

public class EfestoClassKeyDeserializer
extends StdDeserializer<EfestoClassKey> {
    private static final long serialVersionUID = -3468047979532504909L;

    public EfestoClassKeyDeserializer() {
        this(null);
    }

    public EfestoClassKeyDeserializer(Class<EfestoClassKey> t) {
        super(t);
    }

    public EfestoClassKey deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        try {
            String rawTypeString = node.get("rawType").asText();
            Class<?> rawType = Class.forName(rawTypeString);
            ArrayNode typeArgumentsNode = (ArrayNode)node.get("actualTypeArguments");
            ArrayList typeArguments = new ArrayList();
            Iterator typeArgumentsIterator = typeArgumentsNode.elements();
            while (typeArgumentsIterator.hasNext()) {
                JsonNode typeArgumentNode = (JsonNode)typeArgumentsIterator.next();
                String typeArgumentString = typeArgumentNode.asText();
                Class<?> argumentType = Class.forName(typeArgumentString);
                typeArguments.add(argumentType);
            }
            return typeArguments.isEmpty() ? new EfestoClassKey(rawType, new Type[0]) : new EfestoClassKey(rawType, typeArguments.toArray(new Type[0]));
        }
        catch (Exception e) {
            throw new KieEfestoCommonException(String.format("Failed to deserialize %s as EfestoClassKey", node), (Throwable)e);
        }
    }
}

