/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.model.GeneratedResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.core.serialization.DeserializerService;
import org.kie.efesto.common.core.serialization.SerializerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)JSONUtils.class.getName());
    private static final ServiceLoader<DeserializerService> deserializerServiceServiceLoader = ServiceLoader.load(DeserializerService.class);
    private static final ServiceLoader<SerializerService> serializerServiceServiceLoader = ServiceLoader.load(SerializerService.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JSONUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static String getGeneratedResourceString(GeneratedResource generatedResource) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)generatedResource);
    }

    public static GeneratedResource getGeneratedResourceObject(String generatedResourceString) throws JsonProcessingException {
        return (GeneratedResource)objectMapper.readValue(generatedResourceString, GeneratedResource.class);
    }

    public static String getGeneratedResourcesString(GeneratedResources generatedResources) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)generatedResources);
    }

    public static GeneratedResources getGeneratedResourcesObject(String generatedResourcesString) throws JsonProcessingException {
        return (GeneratedResources)objectMapper.readValue(generatedResourcesString, GeneratedResources.class);
    }

    public static GeneratedResources getGeneratedResourcesObject(IndexFile indexFile) throws IOException {
        logger.debug("getGeneratedResourcesObject {}", (Object)indexFile);
        logger.debug("indexFile.length() {}", (Object)indexFile.length());
        return indexFile.length() == 0L ? new GeneratedResources() : (GeneratedResources)objectMapper.readValue(indexFile.getContent(), GeneratedResources.class);
    }

    public static void writeGeneratedResourcesObject(GeneratedResources toWrite, IndexFile indexFile) throws IOException {
        objectMapper.writeValue((File)indexFile, (Object)toWrite);
    }

    public static String getModelLocalUriIdString(ModelLocalUriId localUriId) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)localUriId);
    }

    public static ModelLocalUriId getModelLocalUriIdObject(String localUriString) throws JsonProcessingException {
        return (ModelLocalUriId)objectMapper.readValue(localUriString, ModelLocalUriId.class);
    }

    public static Map<String, Object> getInputData(String inputDataString) throws JsonProcessingException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        String toRead = JSONUtils.cleanupMapString(inputDataString);
        return (Map)objectMapper.readValue(toRead, (TypeReference)typeRef);
    }

    static String cleanupMapString(String toClean) {
        String toReturn = toClean.replaceAll("^\"|\"$", "").replaceAll("\\\\", "");
        if (toReturn.startsWith("\"")) {
            toReturn = toReturn.substring(1);
        }
        if (toReturn.endsWith("\"")) {
            toReturn = toReturn.substring(0, toReturn.length() - 1);
        }
        return toReturn;
    }

    static {
        SimpleModule toRegister = new SimpleModule();
        deserializerServiceServiceLoader.forEach(deserializerService -> {
            logger.debug("Registering deserializer {} for {}", deserializerService.deser(), deserializerService.type());
            toRegister.addDeserializer(deserializerService.type(), deserializerService.deser());
        });
        serializerServiceServiceLoader.forEach(serializerService -> {
            logger.debug("Registering serializer {} for {}", serializerService.ser(), serializerService.type());
            toRegister.addSerializer(serializerService.type(), serializerService.ser());
        });
        objectMapper.registerModule((Module)toRegister);
    }
}

