/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.kie.efesto.common.api.cache.EfestoClassKey;
import org.kie.efesto.common.api.cache.EfestoIdentifierClassKey;
import org.kie.efesto.common.api.exceptions.KieEfestoCommonException;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.core.utils.JSONUtils;

public class EfestoIdentifierClassKeyDeserializer
extends StdDeserializer<EfestoIdentifierClassKey> {
    private static final long serialVersionUID = -3468047979532504909L;

    public EfestoIdentifierClassKeyDeserializer() {
        this(null);
    }

    public EfestoIdentifierClassKeyDeserializer(Class<EfestoIdentifierClassKey> t) {
        super(t);
    }

    public EfestoIdentifierClassKey deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        try {
            String modelLocalUriIdString = node.get("modelLocalUriId").toString();
            ModelLocalUriId modelLocalUriId = (ModelLocalUriId)JSONUtils.getObjectMapper().readValue(modelLocalUriIdString, ModelLocalUriId.class);
            String efestoClassKeyString = node.get("efestoClassKey").toString();
            EfestoClassKey efestoClassKey = (EfestoClassKey)JSONUtils.getObjectMapper().readValue(efestoClassKeyString, EfestoClassKey.class);
            return new EfestoIdentifierClassKey(modelLocalUriId, efestoClassKey);
        }
        catch (Exception e) {
            throw new KieEfestoCommonException(String.format("Failed to deserialize %s as EfestoIdentifierClassKey", node), (Throwable)e);
        }
    }
}

