/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.nio.file.Path;
import java.nio.file.Paths;

public class PathUtils {
    private PathUtils() {
    }

    public static Path getSecuredPath(Path basePath, String userPathStr) {
        Path targetPath = basePath.resolve(userPathStr).normalize();
        if (!targetPath.startsWith(basePath)) {
            throw new SecurityException("Path traversal attempt detected: " + userPathStr);
        }
        String securePath = PathUtils.trimTrailingSeparator(targetPath.toString().replace('\\', '/'));
        return Paths.get(securePath, new String[0]);
    }

    public static Path getSecuredPath(String basePathStr, String userPathStr) {
        Path basePath = Paths.get(basePathStr, new String[0]).normalize();
        return PathUtils.getSecuredPath(basePath, userPathStr);
    }

    public static String trimTrailingSeparator(String p) {
        return !p.isEmpty() && p.charAt(p.length() - 1) == '/' ? p.substring(0, p.length() - 1) : p;
    }
}

