/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.DMNScenarioRunner;
import org.drools.scenariosimulation.backend.runner.IndexedScenarioAssertionError;
import org.drools.scenariosimulation.backend.runner.IndexedScenarioException;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunner;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.ScenarioRunnerProvider;
import org.drools.scenariosimulation.backend.runner.SimulationRunMetadataBuilder;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerDTO;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.kie.api.runtime.KieContainer;

@Deprecated(since="10.2.0", forRemoval=true)
public abstract class AbstractScenarioRunner
extends Runner {
    protected final ClassLoader classLoader;
    protected final ExpressionEvaluatorFactory expressionEvaluatorFactory;
    protected final Description desc;
    protected final KieContainer kieContainer;
    protected final ScenarioRunnerDTO scenarioRunnerDTO;
    protected SimulationRunMetadataBuilder simulationRunMetadataBuilder;

    protected AbstractScenarioRunner(KieContainer kieContainer, ScenarioRunnerDTO scenarioRunnerDTO, ExpressionEvaluatorFactory expressionEvaluatorFactory) {
        this.kieContainer = kieContainer;
        this.scenarioRunnerDTO = scenarioRunnerDTO;
        this.desc = AbstractScenarioRunner.getDescriptionForSimulation(this.getFilePath(), scenarioRunnerDTO.getScenarioWithIndices());
        this.classLoader = kieContainer.getClassLoader();
        this.expressionEvaluatorFactory = expressionEvaluatorFactory;
    }

    public static Description getDescriptionForSimulation(Optional<String> fullFileName, List<ScenarioWithIndex> scenarios) {
        String testSuiteName = fullFileName.isPresent() ? AbstractScenarioRunner.getScesimFileName(fullFileName.get()) : AbstractScenarioRunner.class.getSimpleName();
        Description suiteDescription = Description.createSuiteDescription((String)testSuiteName, (Annotation[])new Annotation[0]);
        scenarios.forEach(scenarioWithIndex -> suiteDescription.addChild(AbstractScenarioRunner.getDescriptionForScenario(fullFileName, scenarioWithIndex.getIndex(), ((Scenario)scenarioWithIndex.getScesimData()).getDescription())));
        return suiteDescription;
    }

    public static Description getDescriptionForScenario(Optional<String> fullFileName, int index, String description) {
        String testName = fullFileName.isPresent() ? AbstractScenarioRunner.getScesimFileName(fullFileName.get()) : AbstractScenarioRunner.class.getSimpleName();
        return Description.createTestDescription((String)testName, (String)String.format("#%d: %s", index, description), (Annotation[])new Annotation[0]);
    }

    public static String getScesimFileName(String fileFullPath) {
        if (fileFullPath == null) {
            return null;
        }
        int idx = fileFullPath.replace("\\", "/").lastIndexOf(47);
        String fileName = idx >= 0 ? fileFullPath.substring(idx + 1) : fileFullPath;
        return fileName.endsWith(".scesim") ? fileName.substring(0, fileName.lastIndexOf(".scesim")) : fileName;
    }

    public static ScenarioRunnerProvider getSpecificRunnerProvider(ScenarioSimulationModel.Type type) {
        if (ScenarioSimulationModel.Type.RULE.equals((Object)type)) {
            return RuleScenarioRunner::new;
        }
        if (ScenarioSimulationModel.Type.DMN.equals((Object)type)) {
            return DMNScenarioRunner::new;
        }
        throw new IllegalArgumentException("Impossible to run simulation of type " + type);
    }

    public void run(RunNotifier notifier) {
        this.simulationRunMetadataBuilder = SimulationRunMetadataBuilder.create();
        notifier.fireTestStarted(this.getDescription());
        for (ScenarioWithIndex scenarioWithIndex : this.scenarioRunnerDTO.getScenarioWithIndices()) {
            this.singleRunScenario(scenarioWithIndex, notifier, this.scenarioRunnerDTO.getSettings(), this.scenarioRunnerDTO.getBackground()).ifPresent(this.simulationRunMetadataBuilder::addScenarioResultMetadata);
        }
        notifier.fireTestStarted(this.getDescription());
    }

    public Description getDescription() {
        return this.desc;
    }

    protected Optional<ScenarioResultMetadata> singleRunScenario(ScenarioWithIndex scenarioWithIndex, RunNotifier runNotifier, Settings settings, Background background) {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        String scenarioName = ((Scenario)scenarioWithIndex.getScesimData()).getDescription();
        int index = scenarioWithIndex.getIndex();
        Description descriptionForScenario = AbstractScenarioRunner.getDescriptionForScenario(this.getFilePath(), index, scenarioName);
        runNotifier.fireTestStarted(descriptionForScenario);
        try {
            this.internalRunScenario(scenarioWithIndex, scenarioRunnerData, settings, background);
        }
        catch (Exception e) {
            runNotifier.fireTestFailure(new Failure(descriptionForScenario, this.defineFailureException(e, index, scenarioName)));
        }
        runNotifier.fireTestFinished(descriptionForScenario);
        return scenarioRunnerData.getMetadata();
    }

    private Throwable defineFailureException(Exception e, int index, String scenarioName) {
        if (e instanceof ScenarioException && ((ScenarioException)e).isFailedAssertion()) {
            return new IndexedScenarioAssertionError(index, scenarioName, AbstractScenarioRunner.getScesimFileName(this.scenarioRunnerDTO.getFileName()), e);
        }
        return new IndexedScenarioException(index, scenarioName, AbstractScenarioRunner.getScesimFileName(this.scenarioRunnerDTO.getFileName()), e);
    }

    protected void internalRunScenario(ScenarioWithIndex scenarioWithIndex, ScenarioRunnerData scenarioRunnerData, Settings settings, Background background) {
        this.newRunnerHelper().run(this.getKieContainer(), this.scenarioRunnerDTO.getSimulationModelDescriptor(), scenarioWithIndex, this.expressionEvaluatorFactory, this.getClassLoader(), scenarioRunnerData, settings, background);
    }

    public Optional<String> getFilePath() {
        return Optional.ofNullable(this.scenarioRunnerDTO.getFileName());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public Optional<SimulationRunMetadata> getLastRunResultMetadata() {
        return this.simulationRunMetadataBuilder != null ? Optional.of(this.simulationRunMetadataBuilder.build()) : Optional.empty();
    }

    protected abstract AbstractRunnerHelper newRunnerHelper();
}

