/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.scenariosimulation.backend.util.DMNSimulationUtils;
import org.drools.util.ResourceHelper;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.RequestContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.identifiers.DmnIdFactory;
import org.kie.dmn.api.identifiers.KieDmnComponentRoot;
import org.kie.dmn.api.identifiers.LocalComponentIdDmn;
import org.kie.dmn.efesto.runtime.model.EfestoOutputDMN;
import org.kie.efesto.common.api.identifiers.EfestoAppRoot;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.common.api.model.GeneratedModelResource;
import org.kie.efesto.common.api.model.GeneratedResources;

public class DMNScenarioExecutableBuilder {
    public static final String DMN_RESULT = "dmnResult";
    public static final String DMN_MODEL = "dmnModel";
    private final Map<String, Object> dmnContext = new HashMap<String, Object>();
    DMNModel dmnModel;
    ModelLocalUriId dmnModelLocalUriId;
    final Map<String, GeneratedResources> generatedResourcesMap;

    private DMNScenarioExecutableBuilder(Map<String, GeneratedResources> generatedResourcesMap) {
        this.generatedResourcesMap = generatedResourcesMap;
    }

    public static DMNScenarioExecutableBuilder createBuilder() {
        try {
            Collection dmnFiles = ResourceHelper.getFileResourcesByExtension((String)"dmn");
            Map<String, GeneratedResources> generatedResourcesMap = DMNSimulationUtils.compileModels(dmnFiles);
            return new DMNScenarioExecutableBuilder(generatedResourcesMap);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setActiveModel(String fileName, String modelName) {
        GeneratedResources dmnGeneratedResources = this.generatedResourcesMap.get("dmn");
        LocalComponentIdDmn targetModelLocalUriId = ((DmnIdFactory)((KieDmnComponentRoot)new EfestoAppRoot().get(KieDmnComponentRoot.class)).get(DmnIdFactory.class)).get(fileName, modelName);
        GeneratedModelResource generatedModelResource = dmnGeneratedResources.stream().filter(GeneratedModelResource.class::isInstance).map(GeneratedModelResource.class::cast).filter(arg_0 -> DMNScenarioExecutableBuilder.lambda$setActiveModel$0((ModelLocalUriId)targetModelLocalUriId, arg_0)).findFirst().orElseThrow(() -> DMNScenarioExecutableBuilder.lambda$setActiveModel$1((ModelLocalUriId)targetModelLocalUriId));
        this.dmnModelLocalUriId = generatedModelResource.getModelLocalUriId();
        this.dmnModel = (DMNModel)generatedModelResource.getCompiledModel();
    }

    public void setValue(String key, Object value) {
        this.dmnContext.put(key, value);
    }

    public RequestContext run() {
        EfestoOutputDMN efestoOutput = (EfestoOutputDMN)DMNSimulationUtils.getEfestoOutput(this.generatedResourcesMap, this.dmnModelLocalUriId, this.dmnContext);
        RequestContext requestContext = (RequestContext)ExecutableRunner.create().createContext();
        requestContext.setResult(efestoOutput.getOutputData());
        requestContext.setOutput(DMN_MODEL, (Object)this.dmnModel);
        requestContext.setOutput(DMN_RESULT, efestoOutput.getOutputData());
        return requestContext;
    }

    private static /* synthetic */ IllegalStateException lambda$setActiveModel$1(ModelLocalUriId targetModelLocalUriId) {
        return new IllegalStateException("Could not find generated model resource for " + targetModelLocalUriId);
    }

    private static /* synthetic */ boolean lambda$setActiveModel$0(ModelLocalUriId targetModelLocalUriId, GeneratedModelResource genRes) {
        return genRes.getModelLocalUriId().equals((Object)targetModelLocalUriId);
    }
}

