/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.accessors;

import java.lang.reflect.Method;
import org.drools.base.base.BaseClassFieldReader;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;

public abstract class BaseDecimalClassFieldReader
extends BaseClassFieldReader {
    private static final long serialVersionUID = 510L;

    protected BaseDecimalClassFieldReader(int index, Class fieldType, ValueType valueType) {
        super(index, fieldType, ValueType.DOUBLE_TYPE);
    }

    public BaseDecimalClassFieldReader() {
    }

    public Object getValue(ValueResolver valueResolver, Object object) {
        double value = this.getDecimalValue(valueResolver, object);
        if (this.getExtractToClass() == Float.TYPE) {
            return Float.valueOf((float)value);
        }
        return value;
    }

    public boolean getBooleanValue(ValueResolver valueResolver, Object object) {
        throw new RuntimeException("Conversion to boolean not supported from double");
    }

    public abstract double getDecimalValue(ValueResolver var1, Object var2);

    public long getWholeNumberValue(ValueResolver valueResolver, Object object) {
        return (long)this.getDecimalValue(valueResolver, object);
    }

    public boolean isNullValue(ValueResolver valueResolver, Object object) {
        return false;
    }

    public Method getNativeReadMethod() {
        try {
            return ((Object)((Object)this)).getClass().getDeclaredMethod("getDecimalValue", ValueResolver.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public int getHashCode(ValueResolver valueResolver, Object object) {
        long temp = Double.doubleToLongBits(this.getDecimalValue(valueResolver, object));
        return (int)(temp ^ temp >>> 32);
    }
}

