/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.AccumulateContextEntry;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Accumulate;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.accessor.Accumulator;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReturnValueExpression;
import org.drools.base.rule.accessor.Wireable;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.EvalNodeLeftTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleImpl;
import org.drools.core.util.index.TupleListWithContext;
import org.kie.api.runtime.rule.FactHandle;

public class MVELGroupByAccumulate
extends Accumulate {
    private Accumulate innerAccumulate;
    private Declaration[] groupingDeclarations;
    private ReturnValueExpression groupingFunction;
    private boolean isMvel;

    public MVELGroupByAccumulate() {
    }

    public MVELGroupByAccumulate(Accumulate innerAccumulate, Declaration[] groupingDeclarations, ReturnValueExpression groupingFunction, boolean isMvel) {
        super(innerAccumulate.getSource(), innerAccumulate.getRequiredDeclarations());
        this.innerAccumulate = innerAccumulate;
        this.groupingDeclarations = groupingDeclarations;
        this.groupingFunction = groupingFunction;
        this.isMvel = isMvel;
    }

    public Accumulate getInnerAccumulate() {
        return this.innerAccumulate;
    }

    private Object getKey(Tuple tuple, FactHandle handle, ValueResolver reteEvaluator) {
        try {
            Tuple keyTuple = this.isMvel ? tuple : new EvalNodeLeftTuple((InternalFactHandle)handle, (TupleImpl)tuple, tuple.getSink());
            FieldValue out = this.groupingFunction.evaluate(handle, (BaseTuple)keyTuple, this.groupingDeclarations, this.getInnerDeclarationCache(), reteEvaluator, this.groupingFunction.createContext());
            return out.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Grouping function threw an exception", e);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.innerAccumulate = (Accumulate)in.readObject();
        this.groupingDeclarations = (Declaration[])in.readObject();
        this.groupingFunction = (ReturnValueExpression)in.readObject();
        this.isMvel = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.innerAccumulate);
        out.writeObject(this.groupingDeclarations);
        out.writeObject(this.groupingFunction);
        out.writeBoolean(this.isMvel);
    }

    public Accumulator[] getAccumulators() {
        return this.innerAccumulate.getAccumulators();
    }

    public Object createFunctionContext() {
        return this.innerAccumulate.createFunctionContext();
    }

    public Object init(Object workingMemoryContext, Object accContext, Object funcContext, BaseTuple leftTuple, ValueResolver valueResolver) {
        return funcContext;
    }

    public Object accumulate(Object workingMemoryContext, Object context, BaseTuple match, FactHandle handle, ValueResolver valueResolver) {
        AccumulateNode.GroupByContext groupByContext = (AccumulateNode.GroupByContext)context;
        TupleListWithContext tupleList = groupByContext.getGroup(workingMemoryContext, this.innerAccumulate, match, this.getKey((Tuple)match, handle, valueResolver), valueResolver);
        return this.accumulate(workingMemoryContext, match, handle, groupByContext, tupleList, valueResolver);
    }

    public Object accumulate(Object workingMemoryContext, BaseTuple match, FactHandle handle, Object groupByContext, Object tupleList, ValueResolver valueResolver) {
        TupleListWithContext list = (TupleListWithContext)tupleList;
        ((AccumulateNode.GroupByContext)groupByContext).moveToPropagateTupleList(list);
        return this.innerAccumulate.accumulate(workingMemoryContext, list.getContext(), match, handle, valueResolver);
    }

    public boolean tryReverse(Object workingMemoryContext, Object context, BaseTuple leftTuple, FactHandle handle, BaseTuple match, ValueResolver valueResolver) {
        TupleImpl tupleMatch = (TupleImpl)match;
        TupleListWithContext memory = (TupleListWithContext)tupleMatch.getMemory();
        AccumulateContextEntry entry = (AccumulateContextEntry)memory.getContext();
        boolean reversed = this.innerAccumulate.tryReverse(workingMemoryContext, (Object)entry, leftTuple, handle, match, valueResolver);
        if (reversed) {
            AccumulateNode.GroupByContext groupByContext = (AccumulateNode.GroupByContext)context;
            groupByContext.moveToPropagateTupleList(memory);
            memory.remove(tupleMatch);
            if (memory.isEmpty()) {
                groupByContext.removeGroup(entry.getKey());
                ((AccumulateContextEntry)memory.getContext()).setEmpty(true);
            }
        }
        return reversed;
    }

    public Object getResult(Object workingMemoryContext, Object context, BaseTuple leftTuple, ValueResolver valueResolver) {
        AccumulateContextEntry entry = (AccumulateContextEntry)context;
        return entry.isEmpty() ? null : this.innerAccumulate.getResult(workingMemoryContext, context, leftTuple, valueResolver);
    }

    public boolean supportsReverse() {
        return this.innerAccumulate.supportsReverse();
    }

    public Accumulate clone() {
        return new MVELGroupByAccumulate(this.innerAccumulate.clone(), this.groupingDeclarations, this.groupingFunction, this.isMvel);
    }

    public Object createWorkingMemoryContext() {
        return this.innerAccumulate.createWorkingMemoryContext();
    }

    public boolean isMultiFunction() {
        return this.innerAccumulate.isMultiFunction();
    }

    public void replaceAccumulatorDeclaration(Declaration declaration, Declaration resolved) {
        this.innerAccumulate.replaceAccumulatorDeclaration(declaration, resolved);
    }

    public boolean isGroupBy() {
        return true;
    }

    public class GroupingFunctionWirer
    implements Wireable {
        public void wire(Object object) {
            ReturnValueExpression expression;
            MVELGroupByAccumulate.this.groupingFunction = expression = (ReturnValueExpression)object;
            for (Accumulate clone : MVELGroupByAccumulate.this.cloned) {
                ((MVELGroupByAccumulate)clone).groupingFunction = expression;
            }
        }
    }
}

