/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.io.IOException;
import java.io.InputStream;
import org.drools.mvel.asm.DumpMethodVisitor;
import org.drools.util.IoUtils;
import org.mvel2.asm.AnnotationVisitor;
import org.mvel2.asm.Attribute;
import org.mvel2.asm.ClassReader;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.MethodVisitor;

public class MethodComparator {
    public boolean equivalent(String method1, ClassReader class1, String method2, ClassReader class2) {
        return this.getMethodBytecode(method1, class1).equals(this.getMethodBytecode(method2, class2));
    }

    public String getMethodBytecode(String methodName, ClassReader classReader) {
        Tracer visit = new Tracer(methodName);
        classReader.accept((ClassVisitor)visit, 2);
        return visit.getText();
    }

    public static String getMethodBytecode(String methodName, byte[] bytes) {
        Tracer visit = new Tracer(methodName);
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)visit, 2);
        return visit.getText();
    }

    public static boolean compareBytecode(String b1, String b2) {
        return b1.equals(b2);
    }

    public static String getMethodBytecode(Class cls, String ruleClassName, String packageName, String methodName, String resource) {
        String string;
        block8: {
            InputStream is = cls.getClassLoader().getResourceAsStream(resource);
            try {
                byte[] data = IoUtils.readBytesFromInputStream((InputStream)is);
                Tracer visit = new Tracer(methodName);
                new ClassReader(data).accept((ClassVisitor)visit, 2);
                string = visit.getText();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable getResourceAsStream for Class '" + ruleClassName + "' ");
                }
            }
            is.close();
        }
        return string;
    }

    public static class Tracer
    extends ClassVisitor {
        private String methodName;
        private String text;

        public Tracer(String methodName) {
            super(458752);
            this.methodName = methodName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new DummyAnnotationVisitor();
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return this.methodName.equals(name) ? new DumpMethodVisitor(this::setText) : null;
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public void visitSource(String source, String debug) {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    static class DummyAnnotationVisitor
    extends AnnotationVisitor {
        public DummyAnnotationVisitor() {
            super(458752);
        }

        public void visit(String name, Object value) {
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new DummyAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String name) {
            return new DummyAnnotationVisitor();
        }

        public void visitEnd() {
        }

        public void visitEnum(String name, String desc, String value) {
        }
    }
}

