/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.antlr4;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.antlr4.DRL10Lexer;
import org.drools.drl.parser.antlr4.DRL10Parser;
import org.drools.drl.parser.antlr4.DRLParserException;
import org.drools.drl.parser.antlr4.DRLVisitorImpl;
import org.drools.drl.parser.antlr4.ParserHelper;
import org.kie.api.io.Resource;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DRL10ParserHelper {
    private DRL10ParserHelper() {
    }

    public static PackageDescr parse(String drl) {
        DRL10Parser drlParser = DRL10ParserHelper.createDrlParser(drl);
        return DRL10ParserHelper.compilationUnitContext2PackageDescr(drlParser.compilationUnit(), drlParser.getTokenStream(), null);
    }

    public static DRL10Parser createDrlParser(String drl) {
        CodePointCharStream charStream = CharStreams.fromString((String)drl);
        return DRL10ParserHelper.createDrlParser((CharStream)charStream);
    }

    public static DRL10Parser createDrlParser(InputStream is, String encoding) {
        try {
            CharStream charStream = encoding != null ? CharStreams.fromStream((InputStream)is, (Charset)Charset.forName(encoding)) : CharStreams.fromStream((InputStream)is);
            return DRL10ParserHelper.createDrlParser(charStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static DRL10Parser createDrlParser(Reader reader) {
        try {
            CodePointCharStream charStream = CharStreams.fromReader((Reader)reader);
            return DRL10ParserHelper.createDrlParser((CharStream)charStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static DRL10Parser createDrlParser(CharStream charStream) {
        DRL10Lexer drlLexer = new DRL10Lexer(charStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)drlLexer);
        DRL10Parser parser = new DRL10Parser((TokenStream)commonTokenStream);
        ParserHelper helper = new ParserHelper((TokenStream)commonTokenStream, LanguageLevelOption.DRL10);
        parser.setHelper(helper);
        return parser;
    }

    public static PackageDescr compilationUnitContext2PackageDescr(DRL10Parser.CompilationUnitContext ctx, TokenStream tokenStream, Resource resource) {
        DRLVisitorImpl visitor = new DRLVisitorImpl(tokenStream, resource);
        Object descr = visitor.visit((ParseTree)ctx);
        if (descr instanceof PackageDescr) {
            return (PackageDescr)descr;
        }
        throw new DRLParserException("CompilationUnitContext should produce PackageDescr. descr = " + descr.getClass());
    }

    public static Integer computeTokenIndex(DRL10Parser parser, int row, int col) {
        for (int i = 0; i < parser.getInputStream().size(); ++i) {
            Token token = parser.getInputStream().get(i);
            int start = token.getCharPositionInLine();
            int stop = token.getCharPositionInLine() + token.getText().length();
            if (token.getLine() > row) {
                return token.getTokenIndex() - 1;
            }
            if (token.getLine() == row && start >= col) {
                return token.getTokenIndex() == 0 ? 0 : token.getTokenIndex() - 1;
            }
            if (token.getLine() != row || start >= col || stop < col) continue;
            return token.getTokenIndex();
        }
        return null;
    }

    public static String getTextWithoutErrorNode(ParseTree tree) {
        if (tree.getChildCount() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tree.getChildCount(); ++i) {
            ParseTree child = tree.getChild(i);
            if (child instanceof ErrorNode) continue;
            if (child instanceof TerminalNode) {
                builder.append(child.getText());
                continue;
            }
            builder.append(DRL10ParserHelper.getTextWithoutErrorNode(child));
        }
        return builder.toString();
    }
}

