/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.assertj.core.api.Assertions;
import org.drools.core.util.KieFunctions;
import org.junit.jupiter.api.Test;

public class KieFunctionsTest {
    @Test
    public void testKieFunctions() {
        Assertions.assertThat((boolean)KieFunctions.isNull(null)).isTrue();
        Assertions.assertThat((boolean)KieFunctions.isNull((Object)"nothing")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.isEmpty(null)).isTrue();
        Assertions.assertThat((boolean)KieFunctions.isEmpty((String)"")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.isEmpty((String)" ")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((Number)55, (String)"55")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((Number)55, (String)"550")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((Number)new BigDecimal("322.123"), (String)"322.123")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((Number)new BigDecimal("322.123"), (String)"3322.123")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((Number)new BigInteger("123456"), (String)"123456")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((Number)new BigInteger("123456"), (String)"1234567")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((String)null, null)).isTrue();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((String)null, (String)"a")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((String)"f", null)).isFalse();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((Number)null, null)).isTrue();
        Assertions.assertThat((boolean)KieFunctions.equalsTo((Number)null, (String)"1")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.equalsToIgnoreCase(null, null)).isTrue();
        Assertions.assertThat((boolean)KieFunctions.equalsToIgnoreCase((String)"TEST", (String)"test")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.equalsToIgnoreCase(null, (String)"a")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.equalsToIgnoreCase((String)"f", null)).isFalse();
        boolean comparitionFailed = false;
        try {
            Assertions.assertThat((boolean)KieFunctions.equalsTo((Number)44, null)).isFalse();
        }
        catch (RuntimeException e) {
            comparitionFailed = true;
        }
        Assertions.assertThat((boolean)comparitionFailed).isTrue();
        Assertions.assertThat((boolean)KieFunctions.contains((String)"welcome to jamaica", (String)"jama")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.contains((String)"welcome to jamaica", (String)"Jama")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.contains(null, null)).isTrue();
        Assertions.assertThat((boolean)KieFunctions.contains((String)"hello", null)).isFalse();
        Assertions.assertThat((boolean)KieFunctions.contains(null, (String)"hello")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.startsWith((String)"welcome to jamaica", (String)"wel")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.startsWith((String)"welcome to jamaica", (String)"Well")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.startsWith(null, null)).isTrue();
        Assertions.assertThat((boolean)KieFunctions.startsWith((String)"hello", null)).isFalse();
        Assertions.assertThat((boolean)KieFunctions.startsWith(null, (String)"hello")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.endsWith((String)"welcome to jamaica", (String)"jamaica")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.endsWith((String)"welcome to jamaica", (String)"Jamaica")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.endsWith(null, null)).isTrue();
        Assertions.assertThat((boolean)KieFunctions.endsWith((String)"hello", null)).isFalse();
        Assertions.assertThat((boolean)KieFunctions.endsWith(null, (String)"hello")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.greaterThan((Number)5, (String)"2")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.greaterThan((Number)0, (String)"2")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.greaterThan((Number)0, (String)"0")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.greaterThan(null, (String)"0")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.greaterThan(null, null)).isFalse();
        comparitionFailed = false;
        try {
            Assertions.assertThat((boolean)KieFunctions.greaterThan((Number)2, null)).isFalse();
        }
        catch (RuntimeException e) {
            comparitionFailed = true;
        }
        Assertions.assertThat((boolean)comparitionFailed).isTrue();
        Assertions.assertThat((boolean)KieFunctions.greaterOrEqualThan((Number)5, (String)"2")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.greaterOrEqualThan((Number)2, (String)"2")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.greaterOrEqualThan((Number)0, (String)"2")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.greaterOrEqualThan((Number)0, (String)"0")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.greaterOrEqualThan(null, (String)"0")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.greaterOrEqualThan(null, null)).isFalse();
        comparitionFailed = false;
        try {
            Assertions.assertThat((boolean)KieFunctions.greaterOrEqualThan((Number)2, null)).isFalse();
        }
        catch (RuntimeException e) {
            comparitionFailed = true;
        }
        Assertions.assertThat((boolean)comparitionFailed).isTrue();
        Assertions.assertThat((boolean)KieFunctions.lessThan((Number)5, (String)"2")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.lessThan((Number)0, (String)"2")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.lessThan((Number)0, (String)"0")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.lessThan(null, (String)"0")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.lessThan(null, null)).isFalse();
        comparitionFailed = false;
        try {
            Assertions.assertThat((boolean)KieFunctions.lessThan((Number)2, null)).isFalse();
        }
        catch (RuntimeException e) {
            comparitionFailed = true;
        }
        Assertions.assertThat((boolean)comparitionFailed).isTrue();
        Assertions.assertThat((boolean)KieFunctions.lessOrEqualThan((Number)5, (String)"2")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.lessOrEqualThan((Number)2, (String)"2")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.lessOrEqualThan((Number)0, (String)"2")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.lessOrEqualThan((Number)0, (String)"0")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.lessOrEqualThan(null, (String)"0")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.lessOrEqualThan(null, null)).isFalse();
        comparitionFailed = false;
        try {
            Assertions.assertThat((boolean)KieFunctions.lessOrEqualThan((Number)2, null)).isFalse();
        }
        catch (RuntimeException e) {
            comparitionFailed = true;
        }
        Assertions.assertThat((boolean)comparitionFailed).isTrue();
        Assertions.assertThat((boolean)KieFunctions.between((Number)0, (String)"1", (String)"10")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.between((Number)11, (String)"1", (String)"10")).isFalse();
        Assertions.assertThat((boolean)KieFunctions.between((Number)1, (String)"1", (String)"10")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.between((Number)10, (String)"1", (String)"10")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.between((Number)2, (String)"1", (String)"10")).isTrue();
        Assertions.assertThat((boolean)KieFunctions.between(null, (String)"5", (String)"6")).isFalse();
        comparitionFailed = false;
        try {
            Assertions.assertThat((boolean)KieFunctions.between((Number)2, null, (String)"9")).isFalse();
        }
        catch (RuntimeException e) {
            comparitionFailed = true;
        }
        Assertions.assertThat((boolean)comparitionFailed).isTrue();
        comparitionFailed = false;
        try {
            Assertions.assertThat((boolean)KieFunctions.between((Number)2, (String)"1", null)).isFalse();
        }
        catch (RuntimeException e) {
            comparitionFailed = true;
        }
        Assertions.assertThat((boolean)comparitionFailed).isTrue();
        Assertions.assertThat((boolean)KieFunctions.isTrue((Boolean)true)).isTrue();
        Assertions.assertThat((boolean)KieFunctions.isTrue(null)).isFalse();
        Assertions.assertThat((boolean)KieFunctions.isTrue((Boolean)false)).isFalse();
        Assertions.assertThat((boolean)KieFunctions.isFalse((Boolean)false)).isTrue();
        Assertions.assertThat((boolean)KieFunctions.isFalse(null)).isFalse();
        Assertions.assertThat((boolean)KieFunctions.isFalse((Boolean)true)).isFalse();
    }
}

