/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;

public class DroolsAssert {
    public static void assertEnumerationSize(int expectedSize, Enumeration<?> enumeration) {
        int actualSize = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++actualSize;
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualSize).as("Enumeration size different than expected.", new Object[0])).isEqualTo(expectedSize);
    }

    public static void assertUrlEnumerationContainsMatch(String regex, Enumeration<URL> enumeration) {
        ArrayList<URL> list = Collections.list(enumeration);
        for (URL url : list) {
            if (!url.toExternalForm().matches(regex)) continue;
            return;
        }
        throw new AssertionError((Object)("The enumeration (" + list + ") does not contain an URL that matches regex (" + regex + ")."));
    }

    private DroolsAssert() {
    }
}

