/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.base.time.Trigger;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.CronTrigger;
import org.drools.core.time.impl.JDKTimerServiceTest;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.junit.jupiter.api.Test;

public class CronJobTest {
    @Test
    public void testCronTriggerJob() throws Exception {
        SessionConfiguration config = (SessionConfiguration)RuleBaseFactory.newKnowledgeSessionConfiguration().as(SessionConfiguration.KEY);
        config.setClockType(ClockType.PSEUDO_CLOCK);
        PseudoClockScheduler timeService = (PseudoClockScheduler)config.createTimerService();
        timeService.advanceTime(0L, TimeUnit.MILLISECONDS);
        CronTrigger trigger = new CronTrigger(0L, null, null, -1, "15 * * * * ?", null, null);
        JDKTimerServiceTest.HelloWorldJobContext ctx = new JDKTimerServiceTest.HelloWorldJobContext("hello world", (TimerService)timeService);
        timeService.scheduleJob((Job)new JDKTimerServiceTest.HelloWorldJob(), (JobContext)ctx, (Trigger)trigger);
        Assertions.assertThat((List)ctx.getList()).hasSize(0);
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        Assertions.assertThat((List)ctx.getList()).hasSize(0);
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        Assertions.assertThat((List)ctx.getList()).hasSize(1);
        timeService.advanceTime(30L, TimeUnit.SECONDS);
        Assertions.assertThat((List)ctx.getList()).hasSize(1);
        timeService.advanceTime(30L, TimeUnit.SECONDS);
        Assertions.assertThat((List)ctx.getList()).hasSize(2);
    }
}

