/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.core.time.impl.CronExpression;
import org.drools.core.time.impl.SerializationTestSupport;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class CronExpressionTest
extends SerializationTestSupport {
    private static final String[] VERSIONS = new String[]{"1.5.2"};
    private static final TimeZone EST_TIME_ZONE = TimeZone.getTimeZone("US/Eastern");

    @Override
    protected Object getTargetObject() throws ParseException {
        CronExpression cronExpression = new CronExpression("0 15 10 * * ? 2005");
        cronExpression.setTimeZone(EST_TIME_ZONE);
        return cronExpression;
    }

    @Override
    protected String[] getVersions() {
        return VERSIONS;
    }

    @Override
    protected void verifyMatch(Object target, Object deserialized) {
        CronExpression targetCronExpression = (CronExpression)target;
        CronExpression deserializedCronExpression = (CronExpression)deserialized;
        Assertions.assertThat((Object)deserializedCronExpression).isNotNull();
        Assertions.assertThat((String)deserializedCronExpression.getCronExpression()).isEqualTo(targetCronExpression.getCronExpression());
        Assertions.assertThat((Object)deserializedCronExpression.getTimeZone()).isEqualTo((Object)targetCronExpression.getTimeZone());
    }

    @Test
    public void testIsSatisfiedBy() throws Exception {
        CronExpression cronExpression = new CronExpression("0 15 10 * * ? 2005");
        Calendar cal = Calendar.getInstance();
        cal.set(2005, 5, 1, 10, 15, 0);
        Assertions.assertThat((boolean)cronExpression.isSatisfiedBy(cal.getTime())).isTrue();
        cal.set(1, 2006);
        Assertions.assertThat((boolean)cronExpression.isSatisfiedBy(cal.getTime())).isFalse();
        cal = Calendar.getInstance();
        cal.set(2005, 5, 1, 10, 16, 0);
        Assertions.assertThat((boolean)cronExpression.isSatisfiedBy(cal.getTime())).isFalse();
        cal = Calendar.getInstance();
        cal.set(2005, 5, 1, 10, 14, 0);
        Assertions.assertThat((boolean)cronExpression.isSatisfiedBy(cal.getTime())).isFalse();
    }

    @Test
    public void testQuartz571() throws Exception {
        CronExpression cronExpression = new CronExpression("19 15 10 4 Apr ? ");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(cronExpression);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        CronExpression newExpression = (CronExpression)ois.readObject();
        Assertions.assertThat((String)cronExpression.getCronExpression()).isEqualTo(newExpression.getCronExpression());
        newExpression.getNextValidTimeAfter(new Date());
    }

    @Test
    public void testQuartz574() {
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression("* * * * Foo ? ");
            Assertions.fail((String)"Expected ParseException did not fire for non-existent month");
        }
        catch (ParseException pe) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)pe.getMessage().startsWith("Invalid Month value:")).as("Incorrect ParseException thrown", new Object[0])).isTrue();
        }
        try {
            cronExpression = new CronExpression("* * * * Jan-Foo ? ");
            Assertions.fail((String)"Expected ParseException did not fire for non-existent month");
        }
        catch (ParseException pe) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)pe.getMessage().startsWith("Invalid Month value:")).as("Incorrect ParseException thrown", new Object[0])).isTrue();
        }
    }

    @Test
    public void testQuartz621() {
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression("0 0 * * * *");
            Assertions.fail((String)"Expected ParseException did not fire for wildcard day-of-month and day-of-week");
        }
        catch (ParseException pe) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)pe.getMessage().startsWith("Support for specifying both or none of day-of-week AND a day-of-month parameters is not implemented.")).as("Incorrect ParseException thrown", new Object[0])).isTrue();
        }
        try {
            cronExpression = new CronExpression("0 0 * 4 * *");
            Assertions.fail((String)"Expected ParseException did not fire for specified day-of-month and wildcard day-of-week");
        }
        catch (ParseException pe) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)pe.getMessage().startsWith("Support for specifying both or none of day-of-week AND a day-of-month parameters is not implemented.")).as("Incorrect ParseException thrown", new Object[0])).isTrue();
        }
        try {
            cronExpression = new CronExpression("0 0 * * * 4");
            Assertions.fail((String)"Expected ParseException did not fire for wildcard day-of-month and specified day-of-week");
        }
        catch (ParseException pe) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)pe.getMessage().startsWith("Support for specifying both or none of day-of-week AND a day-of-month parameters is not implemented.")).as("Incorrect ParseException thrown", new Object[0])).isTrue();
        }
    }

    @Test
    public void testQuartz640() throws ParseException {
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression("0 43 9 1,5,29,L * ?");
            Assertions.fail((String)"Expected ParseException did not fire for L combined with other days of the month");
        }
        catch (ParseException pe) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)pe.getMessage().startsWith("Support for specifying 'L' and 'LW' with other days of the month is not implemented")).as("Incorrect ParseException thrown", new Object[0])).isTrue();
        }
        try {
            cronExpression = new CronExpression("0 43 9 ? * SAT,SUN,L");
            Assertions.fail((String)"Expected ParseException did not fire for L combined with other days of the week");
        }
        catch (ParseException pe) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)pe.getMessage().startsWith("Support for specifying 'L' with other days of the week is not implemented")).as("Incorrect ParseException thrown", new Object[0])).isTrue();
        }
        try {
            cronExpression = new CronExpression("0 43 9 ? * 6,7,L");
            Assertions.fail((String)"Expected ParseException did not fire for L combined with other days of the week");
        }
        catch (ParseException pe) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)pe.getMessage().startsWith("Support for specifying 'L' with other days of the week is not implemented")).as("Incorrect ParseException thrown", new Object[0])).isTrue();
        }
        try {
            CronExpression pe = new CronExpression("0 43 9 ? * 5L");
        }
        catch (ParseException pe) {
            Assertions.fail((String)"Unexpected ParseException thrown for supported '5L' expression.");
        }
    }

    @Override
    @Test
    @Disabled
    public void testSerialization() {
    }
}

