/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.base.time.Interval;
import org.drools.base.time.TimeUtils;
import org.junit.jupiter.api.Test;

public class TemporalDistanceTest {
    public static final long MIN = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;

    @Test
    public void testTemporalDistance() {
        Interval[][] matrix = new Interval[][]{{new Interval(0L, 0L), new Interval(-2L, 2L), new Interval(-3L, 4L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(Long.MIN_VALUE, Long.MAX_VALUE)}, {new Interval(-2L, 2L), new Interval(0L, 0L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(1L, 2L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE)}, {new Interval(-4L, 3L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(0L, 0L), new Interval(2L, 3L), new Interval(Long.MIN_VALUE, Long.MAX_VALUE)}, {new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(-2L, -1L), new Interval(-3L, -2L), new Interval(0L, 0L), new Interval(-2L, -1L)}, {new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(Long.MIN_VALUE, Long.MAX_VALUE), new Interval(1L, 2L), new Interval(0L, 0L)}};
        Interval[][] expected = new Interval[][]{{new Interval(0L, 0L), new Interval(-2L, 2L), new Interval(-3L, 2L), new Interval(-1L, 4L), new Interval(-3L, 3L)}, {new Interval(-2L, 2L), new Interval(0L, 0L), new Interval(-2L, 0L), new Interval(1L, 2L), new Interval(-1L, 1L)}, {new Interval(-2L, 3L), new Interval(0L, 2L), new Interval(0L, 0L), new Interval(2L, 3L), new Interval(0L, 2L)}, {new Interval(-4L, 1L), new Interval(-2L, -1L), new Interval(-3L, -2L), new Interval(0L, 0L), new Interval(-2L, -1L)}, {new Interval(-3L, 3L), new Interval(-1L, 1L), new Interval(-2L, 0L), new Interval(1L, 2L), new Interval(0L, 0L)}};
        Interval[][] result = TimeUtils.calculateTemporalDistance((Interval[][])matrix);
        this.assertEqualsMatrix(expected, result);
    }

    @Test
    public void testTemporalDistance2() {
        Interval[][] matrix = new Interval[][]{{new Interval(0L, 0L), new Interval(5L, 10L), new Interval(65L, Long.MAX_VALUE), new Interval(30L, 40L), new Interval(50L, 55L)}, {new Interval(-10L, -5L), new Interval(0L, 0L), new Interval(60L, Long.MAX_VALUE), new Interval(20L, 35L), new Interval(40L, 50L)}, {new Interval(Long.MIN_VALUE, -65L), new Interval(Long.MIN_VALUE, -60L), new Interval(0L, 0L), new Interval(Long.MIN_VALUE, -25L), new Interval(Long.MIN_VALUE, -10L)}, {new Interval(-40L, -30L), new Interval(-35L, -20L), new Interval(25L, Long.MAX_VALUE), new Interval(0L, 0L), new Interval(15L, 20L)}, {new Interval(-55L, -50L), new Interval(-50L, -40L), new Interval(10L, Long.MAX_VALUE), new Interval(-20L, -15L), new Interval(0L, 0L)}};
        Interval[][] expected = new Interval[][]{{new Interval(0L, 0L), new Interval(5L, 10L), new Interval(65L, Long.MAX_VALUE), new Interval(30L, 40L), new Interval(50L, 55L)}, {new Interval(-10L, -5L), new Interval(0L, 0L), new Interval(60L, Long.MAX_VALUE), new Interval(20L, 35L), new Interval(40L, 50L)}, {new Interval(Long.MIN_VALUE, -65L), new Interval(Long.MIN_VALUE, -60L), new Interval(0L, 0L), new Interval(Long.MIN_VALUE, -25L), new Interval(Long.MIN_VALUE, -10L)}, {new Interval(-40L, -30L), new Interval(-35L, -20L), new Interval(25L, Long.MAX_VALUE), new Interval(0L, 0L), new Interval(15L, 20L)}, {new Interval(-55L, -50L), new Interval(-50L, -40L), new Interval(10L, Long.MAX_VALUE), new Interval(-20L, -15L), new Interval(0L, 0L)}};
        Interval[][] result = TimeUtils.calculateTemporalDistance((Interval[][])matrix);
        this.assertEqualsMatrix(expected, result);
    }

    public void assertEqualsMatrix(Interval[][] expected, Interval[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                ((ObjectAssert)Assertions.assertThat((Object)matrix[i][j]).as("Wrong value at (" + i + ", " + j, new Object[0])).isEqualTo((Object)expected[i][j]);
            }
        }
    }

    public void printMatrix(Interval[][] matrix) {
        System.out.println("------------------------------------------------------------------");
        for (int i = 0; i < matrix.length; ++i) {
            System.out.print("|  ");
            for (int j = 0; j < matrix[i].length; ++j) {
                System.out.print(matrix[i][j] + "  ");
            }
            System.out.println("|");
        }
        System.out.println("------------------------------------------------------------------");
    }
}

