/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ValueResolver;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.GroupElementFactory;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.consequence.Consequence;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.builder.ReteooRuleBuilder;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.internal.conf.CompositeBaseConfiguration;

public class ReteooRuleBuilderTest {
    private ReteooRuleBuilder builder;
    private KnowledgeBaseImpl rulebase;

    @BeforeEach
    public void setUp() throws Exception {
        this.builder = new ReteooRuleBuilder();
        this.rulebase = new KnowledgeBaseImpl("default", (CompositeBaseConfiguration)RuleBaseFactory.newKnowledgeBaseConfiguration());
    }

    @Test
    public void testAddRuleWithPatterns() {
        RuleImpl rule = new RuleImpl("only patterns");
        Pattern c1 = new Pattern(0, (ObjectType)new ClassObjectType(String.class));
        Pattern c2 = new Pattern(1, (ObjectType)new ClassObjectType(String.class));
        Pattern c3 = new Pattern(2, (ObjectType)new ClassObjectType(String.class));
        GroupElement lhsroot = GroupElementFactory.newAndInstance();
        lhsroot.addChild((RuleConditionElement)c1);
        lhsroot.addChild((RuleConditionElement)c2);
        lhsroot.addChild((RuleConditionElement)c3);
        rule.setLhs(lhsroot);
        Consequence<KnowledgeHelper> consequence = new Consequence<KnowledgeHelper>(){

            public void evaluate(KnowledgeHelper knowledgeHelper, ValueResolver valueResolver) throws Exception {
                System.out.println("Consequence!");
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule.setConsequence((Consequence)consequence);
        List terminals = this.builder.addRule((InternalRuleBase)this.rulebase, Collections.emptyList(), rule);
        ((AbstractIntegerAssert)Assertions.assertThat((int)terminals.size()).as("Rule must have a single terminal node", new Object[0])).isEqualTo(1);
        RuleTerminalNode terminal = (RuleTerminalNode)terminals.get(0);
    }
}

