/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.lang.reflect.InvocationTargetException;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.index.IndexSpec;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleIndexRBTree;
import org.drools.util.Config;

public class IndexMemory {
    private static final String INTERNAL_INDEX = "internal";
    private static final String FASTUTIL_INDEX = "fastutil";
    private static final String DEFAULT_INDEX = "internal";
    private static EqualityMemoryType EQUALITY_MEMORY_TYPE = EqualityMemoryType.get(Config.getConfig((String)"org.drools.equalitymemory", (String)"internal"));
    private static ComparisonMemoryType COMPARISON_MEMORY_TYPE = ComparisonMemoryType.get(Config.getConfig((String)"org.drools.comparisonmemory", (String)"internal"));

    public static EqualityMemoryType getEqualityMemoryType() {
        return EQUALITY_MEMORY_TYPE;
    }

    public static void setEqualityMemoryType(EqualityMemoryType type) {
        EQUALITY_MEMORY_TYPE = type;
        EqualityMemoryFactoryHolder.reinit();
    }

    public static ComparisonMemoryType getComparisonMemoryType() {
        return COMPARISON_MEMORY_TYPE;
    }

    public static void setComparisonMemoryType(ComparisonMemoryType type) {
        COMPARISON_MEMORY_TYPE = type;
        ComparisonMemoryFactoryHolder.reinit();
    }

    public static TupleMemory createEqualityMemory(IndexSpec indexSpec, boolean isLeft) {
        return EqualityMemoryFactoryHolder.INSTANCE.createMemory(indexSpec, isLeft);
    }

    public static TupleMemory createComparisonMemory(IndexSpec indexSpec, boolean isLeft) {
        return ComparisonMemoryFactoryHolder.INSTANCE.createMemory(indexSpec, isLeft);
    }

    public static enum EqualityMemoryType {
        INTERNAL,
        FASTUTIL;


        static EqualityMemoryType get(String s) {
            if (s.equalsIgnoreCase(IndexMemory.FASTUTIL_INDEX)) {
                return FASTUTIL;
            }
            return INTERNAL;
        }

        Factory createFactory() {
            if (this == FASTUTIL) {
                try {
                    return (Factory)Class.forName("org.drools.fastutil.FastUtilIndexMemory.FastUtilEqualityMemoryFactory").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("You're trying to use fastutil indexes without having imported them. Please add the module org.drools:drools-fastutil to your classpath.", e);
                }
            }
            return new InternalEqualityMemoryFactory();
        }
    }

    static class EqualityMemoryFactoryHolder {
        private static Factory INSTANCE = EQUALITY_MEMORY_TYPE.createFactory();

        EqualityMemoryFactoryHolder() {
        }

        private static void reinit() {
            INSTANCE = EQUALITY_MEMORY_TYPE.createFactory();
        }
    }

    public static enum ComparisonMemoryType {
        INTERNAL,
        FASTUTIL;


        static ComparisonMemoryType get(String s) {
            if (s.equalsIgnoreCase(IndexMemory.FASTUTIL_INDEX)) {
                return FASTUTIL;
            }
            return INTERNAL;
        }

        Factory createFactory() {
            if (this == FASTUTIL) {
                try {
                    return (Factory)Class.forName("org.drools.fastutil.FastUtilIndexMemory.FastUtilComparisonMemoryFactory").getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("You're trying to use fastutil indexes without having imported them. Please add the module org.drools:drools-fastutil to your classpath.", e);
                }
            }
            return new InternalComparisonMemoryFactory();
        }
    }

    static class ComparisonMemoryFactoryHolder {
        private static Factory INSTANCE = COMPARISON_MEMORY_TYPE.createFactory();

        ComparisonMemoryFactoryHolder() {
        }

        private static void reinit() {
            INSTANCE = COMPARISON_MEMORY_TYPE.createFactory();
        }
    }

    public static interface Factory {
        public TupleMemory createMemory(IndexSpec var1, boolean var2);
    }

    static class InternalComparisonMemoryFactory
    implements Factory {
        InternalComparisonMemoryFactory() {
        }

        @Override
        public TupleMemory createMemory(IndexSpec indexSpec, boolean isLeft) {
            return new TupleIndexRBTree(indexSpec.getConstraintType(), indexSpec.getIndex(0), isLeft);
        }
    }

    static class InternalEqualityMemoryFactory
    implements Factory {
        InternalEqualityMemoryFactory() {
        }

        @Override
        public TupleMemory createMemory(IndexSpec indexSpec, boolean isLeft) {
            return new TupleIndexHashTable(indexSpec.getIndex(), isLeft);
        }
    }
}

